/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.handles.blocks.tiles;

import com.vandendaelen.handles.blocks.HandlesTiles;
import com.vandendaelen.handles.exceptions.NoUpgradeException;
import com.vandendaelen.handles.exceptions.NotATardisException;
import com.vandendaelen.handles.functions.FunctionsHandler;
import com.vandendaelen.handles.misc.TardisInterfacePeripheral;
import com.vandendaelen.handles.tardis.upgrades.AprioritronUpgrade;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.world.dimensions.TDimensions;

public class TardisInterfaceTile
extends TileEntity {
    private LazyOptional<IPeripheral> peripheral;
    private FunctionsHandler functionsHandler;

    public TardisInterfaceTile() {
        super((TileEntityType)HandlesTiles.TARDISINTERFACE_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        return super.func_189515_b(tag);
    }

    public ConsoleTile getTardis() throws NotATardisException {
        DimensionType type = (DimensionType)this.field_145850_b.func_73046_m().func_244267_aX().func_230520_a_().func_230516_a_(TDimensions.DimensionTypes.TARDIS_TYPE);
        if (!this.field_145850_b.func_230315_m_().func_242714_a(type)) {
            throw new NotATardisException();
        }
        ConsoleTile tardis = (ConsoleTile)this.field_145850_b.field_147482_g.stream().filter(tileEntity -> tileEntity instanceof ConsoleTile).findFirst().get();
        return tardis;
    }

    public void damageUpgrade() throws NotATardisException {
        this.damageUpgrade(1);
    }

    public void damageUpgrade(int damage) throws NotATardisException {
        this.getTardis().getUpgrade(AprioritronUpgrade.class).ifPresent(aprioritron -> aprioritron.damage(damage, Upgrade.DamageType.ITEM, null));
    }

    public boolean canBeUsed() throws NotATardisException, NoUpgradeException {
        AprioritronUpgrade upgrade = (AprioritronUpgrade)((Object)this.getTardis().getUpgrade(AprioritronUpgrade.class).orElseThrow(NoUpgradeException::new));
        return upgrade.isUsable() && upgrade.isActivated();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheral == null) {
                this.peripheral = LazyOptional.of(() -> {
                    try {
                        this.functionsHandler = new FunctionsHandler(this.getTardis());
                    }
                    catch (NotATardisException e) {
                        e.printStackTrace();
                    }
                    return new TardisInterfacePeripheral(this);
                });
            }
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.deserializeNBT(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public FunctionsHandler getFunctionsHandler() {
        return this.functionsHandler;
    }

    public void onLoad() {
        super.onLoad();
        this.connectToAprioritron();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.disconnectFromAprioritron();
    }

    public void connectToAprioritron() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        try {
            this.getTardis().getUpgrade(AprioritronUpgrade.class).ifPresent(aprioritron -> aprioritron.attachInterface(this));
        }
        catch (NotATardisException notATardisException) {
            // empty catch block
        }
    }

    public void disconnectFromAprioritron() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        try {
            this.getTardis().getUpgrade(AprioritronUpgrade.class).ifPresent(aprioritron -> aprioritron.detachInterface(this));
        }
        catch (NotATardisException notATardisException) {
            // empty catch block
        }
    }
}

