/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Curtain
extends Block {
    private static final EnumProperty<TiedEnum> TIED = EnumProperty.func_177709_a((String)"tied", TiedEnum.class);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape WEST = VoxelShapes.func_216384_a((VoxelShape)Curtain.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape SOUTH = VoxelShapes.func_216384_a((VoxelShape)Curtain.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST = VoxelShapes.func_216384_a((VoxelShape)Curtain.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = VoxelShapes.func_216384_a((VoxelShape)Curtain.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader getter, BlockPos pos) {
        TiedEnum tied = (TiedEnum)((Object)state.func_177229_b(TIED));
        if (tied == TiedEnum.NONE) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case EAST: {
                    return EAST;
                }
                case WEST: {
                    return WEST;
                }
            }
            return null;
        }
        return VoxelShapes.func_197880_a();
    }

    public Curtain(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(TIED, (Comparable)((Object)TiedEnum.NONE)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void onBroken(World worldIn, BlockPos pos) {
        worldIn.func_217379_c(1029, pos, 0);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void placeAt(World level, BlockPos pos, int num) {
        level.func_180501_a(pos, this.func_176223_P(), num);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean belowIsCurtain;
        BlockPos pos;
        BlockState state = super.func_196258_a(context);
        World world = context.func_195991_k();
        boolean aboveIsCurtain = world.func_180495_p((pos = context.func_195995_a()).func_177984_a()).func_177230_c() == this;
        boolean bl = belowIsCurtain = world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        if (aboveIsCurtain && belowIsCurtain) {
            world.func_180501_a(pos.func_177977_b(), (BlockState)world.func_180495_p(pos.func_177977_b()).func_206870_a(TIED, (Comparable)((Object)TiedEnum.NONE)), 3);
            state = (BlockState)state.func_206870_a(TIED, (Comparable)((Object)TiedEnum.NONE));
        } else if (aboveIsCurtain) {
            state = (BlockState)state.func_206870_a(TIED, (Comparable)((Object)TiedEnum.NONE));
        } else if (belowIsCurtain) {
            state = (BlockState)state.func_206870_a(TIED, (Comparable)((Object)TiedEnum.TOP));
            world.func_180501_a(pos.func_177977_b(), (BlockState)world.func_180495_p(pos.func_177977_b()).func_206870_a(TIED, (Comparable)((Object)TiedEnum.NONE)), 3);
        } else {
            state = (BlockState)state.func_206870_a(TIED, (Comparable)((Object)TiedEnum.TOP));
        }
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean isCrouching = player.func_213453_ef();
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        int cycleDirection = isCrouching ? -1 : 1;
        TiedEnum currentTied = (TiedEnum)((Object)state.func_177229_b(TIED));
        int nextIndex = (currentTied.ordinal() + cycleDirection + TiedEnum.values().length) % TiedEnum.values().length;
        TiedEnum nextTied = TiedEnum.values()[nextIndex];
        state = (BlockState)state.func_206870_a(TIED, (Comparable)((Object)nextTied));
        world.func_180501_a(pos, state, 2);
        return ActionResultType.SUCCESS;
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, World worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.func_196271_a(stateIn, facing, facingState, (IWorld)worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TIED, FACING});
    }

    public static enum TiedEnum implements IStringSerializable
    {
        TOP("top"),
        NONE("none"),
        LEFT("left"),
        RIGHT("right"),
        HALF_RIGHT_TIE("half_right_tie"),
        HALF_RIGHT("half_right"),
        HALF_RIGHT_BOTTOM("half_right_bottom"),
        HALF_LEFT_TIE("half_left_tie"),
        HALF_LEFT("half_left"),
        HALF_LEFT_BOTTOM("half_left_bottom"),
        TOP_WAVE("top_wave"),
        BASE_WAVE("base_wave"),
        TOP_HALF_WAVE("top_half_wave"),
        BASE_HALF_WAVE("base_half_wave");

        private final String name;

        private TiedEnum(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

