/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Fermenter")
@ZenCodeType.Name(value="mods.immersiveengineering.Fermenter")
public class FermenterRecipeManager
implements IRecipeManager {
    public IRecipeType<FermenterRecipe> getRecipeType() {
        return FermenterRecipe.TYPE;
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IItemStack itemOutput, IFluidStack fluidOutput) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        IngredientWithSize ingredient = CrTIngredientUtil.getIngredientWithSize(input);
        FluidStack fluidStack = fluidOutput.getInternal();
        ItemStack outputItem = itemOutput.getInternal();
        FermenterRecipe recipe = new FermenterRecipe(resourceLocation, fluidStack, outputItem, ingredient, energy);
        String outputDescription = String.format("%s and %s", itemOutput.getCommandString(), fluidOutput.getCommandString());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipeCustomOutput((IRecipeManager)this, recipe, outputDescription));
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IFluidStack fluidOutput) {
        this.addRecipe(recipePath, input, energy, (IItemStack)MCItemStack.EMPTY.get(), fluidOutput);
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IItemStack itemOutput) {
        this.addRecipe(recipePath, input, energy, itemOutput, (IFluidStack)new MCFluidStackMutable(FluidStack.EMPTY));
    }

    @ZenCodeType.Method
    public void removeRecipe(final Fluid outputFluid) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<FermenterRecipe>((IRecipeManager)this, outputFluid){

            @Override
            public boolean shouldRemove(FermenterRecipe recipe) {
                return outputFluid.func_207187_a(recipe.fluidOutput.getFluid());
            }
        });
    }

    @ZenCodeType.Method
    public void removeRecipe(final IFluidStack output) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<FermenterRecipe>((IRecipeManager)this, (CommandStringDisplayable)output){

            @Override
            public boolean shouldRemove(FermenterRecipe recipe) {
                return output.getInternal().isFluidStackIdentical(recipe.fluidOutput);
            }
        });
    }
}

