/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic;

import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.ArcFurnaceCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.AssemblerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.AutoWorkbenchCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.BottlingMachineCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.CapacitorCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.CrusherCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.DieselGenCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.EnergyMeterCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.ExcavatorCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.FermenterCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.FloodlightCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.MixerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.RefineryCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SampleDrillCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SawmillCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SiloCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SqueezerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.TeslaCoilCallbacks;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;

public class Callbacks {
    private static final Map<TileEntityType<?>, CallbackOwner<?>> CALLBACKS = new HashMap();
    private static boolean initialized = false;

    private static <T extends TileEntity> void register(RegistryObject<TileEntityType<T>> type, CallbackOwner<T> owner) {
        Preconditions.checkState((!CALLBACKS.containsKey(type.get()) ? 1 : 0) != 0);
        CALLBACKS.put((TileEntityType)type.get(), owner);
    }

    private static void ensureInitialized() {
        if (initialized) {
            return;
        }
        Callbacks.register(IETileTypes.CRUSHER, new CrusherCallbacks());
        Callbacks.register(IETileTypes.ARC_FURNACE, new ArcFurnaceCallbacks());
        Callbacks.register(IETileTypes.BOTTLING_MACHINE, new BottlingMachineCallbacks());
        Callbacks.register(IETileTypes.CAPACITOR_LV, new CapacitorCallbacks("lv"));
        Callbacks.register(IETileTypes.CAPACITOR_MV, new CapacitorCallbacks("mv"));
        Callbacks.register(IETileTypes.CAPACITOR_HV, new CapacitorCallbacks("hv"));
        Callbacks.register(IETileTypes.DIESEL_GENERATOR, new DieselGenCallbacks());
        Callbacks.register(IETileTypes.ENERGY_METER, new EnergyMeterCallbacks());
        Callbacks.register(IETileTypes.EXCAVATOR, new ExcavatorCallbacks());
        Callbacks.register(IETileTypes.FERMENTER, new FermenterCallbacks());
        Callbacks.register(IETileTypes.SQUEEZER, new SqueezerCallbacks());
        Callbacks.register(IETileTypes.MIXER, new MixerCallbacks());
        Callbacks.register(IETileTypes.REFINERY, new RefineryCallbacks());
        Callbacks.register(IETileTypes.FLOODLIGHT, new FloodlightCallbacks());
        Callbacks.register(IETileTypes.SAMPLE_DRILL, new SampleDrillCallbacks());
        Callbacks.register(IETileTypes.TESLACOIL, new TeslaCoilCallbacks());
        Callbacks.register(IETileTypes.ASSEMBLER, new AssemblerCallbacks());
        Callbacks.register(IETileTypes.AUTO_WORKBENCH, new AutoWorkbenchCallbacks());
        Callbacks.register(IETileTypes.SILO, new SiloCallbacks());
        Callbacks.register(IETileTypes.SAWMILL, new SawmillCallbacks());
        initialized = true;
    }

    public static Map<TileEntityType<?>, CallbackOwner<?>> getCallbacks() {
        Callbacks.ensureInitialized();
        return Collections.unmodifiableMap(CALLBACKS);
    }
}

