/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.cctweaked;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorBundledTileEntity;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.GenericPeripheral;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.PeripheralCreator;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callbacks;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class ComputerCraftCompatModule
extends IECompatModule {
    @CapabilityInject(value=IPeripheral.class)
    public static Capability<IPeripheral> PERIPHERAL_CAPABILITY;
    private final Map<TileEntityType<?>, PeripheralCreator<?>> knownPeripherals = new HashMap();
    private static final ResourceLocation CAP_NAME;

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        ComputerCraftAPI.registerBundledRedstoneProvider((world, pos, direction) -> {
            int doNotHandle = -1;
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != IEBlocks.Connectors.connectorBundled) {
                return -1;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof ConnectorBundledTileEntity)) {
                return -1;
            }
            int bits = 0;
            for (int color = 0; color < 16; ++color) {
                if (((ConnectorBundledTileEntity)tile).getValue(color) <= 0) continue;
                bits |= 1 << color;
            }
            return bits;
        });
        ConnectorBundledTileEntity.EXTRA_SOURCES.add((world, emittingBlock, emittingSide) -> {
            int output = ComputerCraftAPI.getBundledRedstoneOutput((World)world, (BlockPos)emittingBlock, (Direction)emittingSide);
            if (output == 0 || output == -1) {
                return null;
            }
            byte[] channelValues = new byte[16];
            for (int color = 0; color < 16; ++color) {
                channelValues[color] = (byte)(15 * (output >> color & 1));
            }
            return channelValues;
        });
        MinecraftForge.EVENT_BUS.addGenericListener(TileEntity.class, this::attachPeripheral);
        try {
            for (Map.Entry<TileEntityType<?>, CallbackOwner<?>> entry : Callbacks.getCallbacks().entrySet()) {
                this.knownPeripherals.put(entry.getKey(), new PeripheralCreator(entry.getValue()));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void postInit() {
    }

    private void attachPeripheral(AttachCapabilitiesEvent<TileEntity> ev) {
        if (PERIPHERAL_CAPABILITY == null) {
            return;
        }
        final TileEntity te = (TileEntity)ev.getObject();
        final PeripheralCreator<?> creator = this.knownPeripherals.get(te.func_200662_C());
        if (creator != null) {
            ev.addCapability(CAP_NAME, new ICapabilityProvider(){
                private final LazyValue<LazyOptional<IPeripheral>> realPeripheral = new LazyValue(() -> {
                    GenericPeripheral peripheral = creator.make(te);
                    if (peripheral != null) {
                        return CapabilityUtils.constantOptional(peripheral);
                    }
                    return LazyOptional.empty();
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == PERIPHERAL_CAPABILITY) {
                        return ((LazyOptional)this.realPeripheral.func_179281_c()).cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }

    static {
        CAP_NAME = ImmersiveEngineering.rl("cc_peripheral");
    }
}

