/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class FaradaySuitItem
extends ArmorItem
implements IElectricEquipment {
    public static IArmorMaterial mat = new FaradayArmorMaterial();

    public FaradaySuitItem(EquipmentSlotType type) {
        super(mat, type, new Item.Properties().func_200917_a(1).func_200916_a(ImmersiveEngineering.ITEM_GROUP));
        String name = "armor_faraday_" + type.func_188450_d().toLowerCase(Locale.ENGLISH);
        this.setRegistryName("immersiveengineering", name);
        IEContent.registeredIEItems.add((Item)this);
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlotType eqSlot, LivingEntity owner, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        if ((double)dmg.source.level < 1.75) {
            if (cache.containsKey("faraday")) {
                cache.put("faraday", 1 << this.field_77881_a.func_188454_b() | (Integer)cache.get("faraday"));
            } else {
                cache.put("faraday", 1 << this.field_77881_a.func_188454_b());
            }
            if (cache.containsKey("faraday") && (Integer)cache.get("faraday") == 15) {
                dmg.dmg = 0.0f;
            }
        } else {
            dmg.dmg = (float)((double)dmg.dmg * 1.2);
            if (!(owner instanceof PlayerEntity && ((PlayerEntity)owner).field_71075_bZ.field_75098_d || !equipped.func_96631_a(2, Item.field_77697_d, dmg.func_76346_g() instanceof ServerPlayerEntity ? (ServerPlayerEntity)dmg.func_76346_g() : null))) {
                owner.func_184201_a(eqSlot, ItemStack.field_190927_a);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "immersiveengineering:textures/models/armor_faraday" + (slot == EquipmentSlotType.LEGS ? "_legs" : "") + ".png";
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private static class FaradayArmorMaterial
    implements IArmorMaterial {
        private FaradayArmorMaterial() {
        }

        public int func_200896_a(@Nonnull EquipmentSlotType slotIn) {
            switch (slotIn) {
                case FEET: {
                    return 13;
                }
                case LEGS: {
                    return 15;
                }
                case CHEST: {
                    return 16;
                }
                case HEAD: {
                    return 11;
                }
            }
            return 0;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            switch (slotIn) {
                case FEET: 
                case HEAD: {
                    return 1;
                }
                case LEGS: {
                    return 2;
                }
                case CHEST: {
                    return 3;
                }
            }
            return 0;
        }

        public int func_200900_a() {
            return 0;
        }

        @Nonnull
        public SoundEvent func_200899_b() {
            return SoundEvents.field_187713_n;
        }

        @Nonnull
        public Ingredient func_200898_c() {
            return Ingredient.field_193370_a;
        }

        @Nonnull
        public String func_200897_d() {
            return "immersiveengineering:faraday";
        }

        public float func_200901_e() {
            return 0.0f;
        }

        public float func_230304_f_() {
            return 0.0f;
        }
    }
}

