/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.wooden.DeskBlock;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CircuitTableTileEntity
extends IEBaseTileEntity
implements IIEInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IInteractionObjectIE,
IModelOffsetProvider {
    public static final BlockPos MASTER_POS = BlockPos.field_177992_a;
    public static final BlockPos DUMMY_POS = new BlockPos(1, 0, 0);
    public static final String[] SLOT_TYPES = new String[]{"backplane", "logic", "solder"};
    private static final int ASSEMBLY_ENERGY = 5000;
    public FluxStorageAdvanced energyStorage = new FluxStorageAdvanced(32000);
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;
    EnergyHelper.IEForgeEnergyWrapper wrapper = null;

    public CircuitTableTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.CIRCUIT_TABLE.get()));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        if (!descPacket) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        if (!descPacket) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
    }

    public static int getIngredientAmount(LogicCircuitHandler.LogicCircuitInstruction instruction, int slot) {
        switch (slot) {
            case 0: {
                return 1;
            }
            case 1: {
                return instruction.getOperator().getComplexity();
            }
            case 2: {
                return (int)Math.ceil((float)(instruction.getOperator().getComplexity() + instruction.getInputs().length + 1) / 2.0f);
            }
        }
        return -1;
    }

    public boolean canAssemble(LogicCircuitHandler.LogicCircuitInstruction instruction) {
        if (this.getFluxStorage().getEnergyStored() < 5000) {
            return false;
        }
        for (int i = 0; i < SLOT_TYPES.length; ++i) {
            ItemStack input = (ItemStack)this.inventory.get(i);
            if (input.func_190916_E() >= CircuitTableTileEntity.getIngredientAmount(instruction, i)) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs(LogicCircuitHandler.LogicCircuitInstruction instruction) {
        this.getFluxStorage().extractEnergy(5000, false);
        for (int i = 0; i < SLOT_TYPES.length; ++i) {
            ((ItemStack)this.inventory.get(i)).func_190918_g(CircuitTableTileEntity.getIngredientAmount(instruction, i));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 2));
        }
        return this.renderAABB;
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        if (!this.isDummy()) {
            return this;
        }
        Direction dummyDir = this.getFacing().func_176735_f();
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dummyDir));
        if (tileEntity instanceof CircuitTableTileEntity) {
            return (CircuitTableTileEntity)tileEntity;
        }
        return null;
    }

    @Override
    @Nonnull
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return IEBlockInterfaces.IInteractionObjectIE.super.createMenu(id, playerInventory, player);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    @Nullable
    public CircuitTableTileEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterTE != null) {
            return (CircuitTableTileEntity)this.tempMasterTE;
        }
        Direction dummyDir = this.isDummy() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
        BlockPos masterPos = this.func_174877_v().func_177972_a(dummyDir);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return te instanceof CircuitTableTileEntity ? (CircuitTableTileEntity)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        DeskBlock.placeDummies(this.func_195044_w(), this.field_145850_b, this.field_174879_c, ctx);
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterTE = this.master();
        Direction dummyDir = this.isDummy() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
        this.field_145850_b.func_217377_a(pos.func_177972_a(dummyDir), false);
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vector3i size) {
        if (this.isDummy()) {
            return DUMMY_POS;
        }
        return MASTER_POS;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        CircuitTableTileEntity te;
        if (this.isDummy() && (te = this.master()) != null) {
            return te.getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    public void postEnergyTransferUpdate(int energy, boolean simulate) {
        if (this.isDummy()) {
            CircuitTableTileEntity te = this.master();
            if (te != null) {
                te.postEnergyTransferUpdate(energy, simulate);
            }
        } else if (!simulate && energy != 0) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return this.isDummy() && facing == this.getFacing() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (this.isDummy() && facing == this.getFacing()) {
            if (this.wrapper == null || this.wrapper.side != this.getFacing()) {
                this.wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, this.getFacing());
            }
            return this.wrapper;
        }
        return null;
    }
}

