/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class WallmountBlock
extends IEBaseBlock {
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.func_177709_a((String)"orientation", Orientation.class);

    public WallmountBlock(String name, AbstractBlock.Properties blockProps) {
        super(name, blockProps, BlockItemIE::new);
        this.lightOpacity = 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{IEProperties.FACING_HORIZONTAL, ORIENTATION, BlockStateProperties.field_208198_y});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState ret = super.func_196258_a(context);
        if (ret == null) {
            return null;
        }
        Direction side = context.func_196000_l();
        Direction facing = Direction.func_176733_a((double)context.func_195990_h());
        if (side.func_176740_k() == Direction.Axis.Y) {
            facing = facing.func_176734_d();
        }
        ret = side == Direction.UP ? (BlockState)ret.func_206870_a(ORIENTATION, (Comparable)((Object)Orientation.VERT_UP)) : (side == Direction.DOWN ? (BlockState)ret.func_206870_a(ORIENTATION, (Comparable)((Object)Orientation.VERT_DOWN)) : (context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() < 0.5 ? (BlockState)ret.func_206870_a(ORIENTATION, (Comparable)((Object)Orientation.SIDE_DOWN)) : (BlockState)ret.func_206870_a(ORIENTATION, (Comparable)((Object)Orientation.SIDE_UP))));
        ret = (BlockState)ret.func_206870_a((Property)IEProperties.FACING_HORIZONTAL, (Comparable)facing);
        return ret;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        double maxX;
        double minX;
        Orientation orientation = (Orientation)((Object)state.func_177229_b(ORIENTATION));
        Direction facing = (Direction)state.func_177229_b((Property)IEProperties.FACING_HORIZONTAL);
        Direction towards = orientation.attachedToSide() ? facing : facing.func_176734_d();
        double d = minX = towards == Direction.WEST ? 0.0 : 0.3125;
        double minY = orientation == Orientation.SIDE_UP ? 0.375 : (orientation == Orientation.VERT_DOWN ? 0.3125 : 0.0);
        double minZ = towards == Direction.NORTH ? 0.0 : 0.3125;
        double d2 = maxX = towards == Direction.EAST ? 1.0 : 0.6875;
        double maxY = orientation == Orientation.SIDE_DOWN ? 0.625 : (orientation == Orientation.VERT_UP ? 0.6875 : 1.0);
        double maxZ = towards == Direction.SOUTH ? 1.0 : 0.6875;
        return VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @Override
    public ActionResultType hammerUseSide(Direction side, PlayerEntity player, Hand hand, World w, BlockPos pos, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            BlockState state = w.func_180495_p(pos);
            Orientation old = (Orientation)((Object)state.func_177229_b(ORIENTATION));
            Orientation newO = old.getDual();
            w.func_175656_a(pos, (BlockState)state.func_206870_a(ORIENTATION, (Comparable)((Object)newO)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static enum Orientation implements IStringSerializable
    {
        SIDE_UP,
        SIDE_DOWN,
        VERT_DOWN,
        VERT_UP;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public boolean attachedToSide() {
            return this == SIDE_DOWN || this == SIDE_UP;
        }

        public boolean touchesTop() {
            return this == SIDE_UP || this == VERT_UP;
        }

        public Orientation getDual() {
            switch (this) {
                case SIDE_UP: {
                    return SIDE_DOWN;
                }
                case SIDE_DOWN: {
                    return SIDE_UP;
                }
                case VERT_UP: {
                    return VERT_DOWN;
                }
            }
            return VERT_UP;
        }

        public String modelSuffix() {
            switch (this) {
                case SIDE_UP: {
                    return "";
                }
                case SIDE_DOWN: {
                    return "_inverted";
                }
                case VERT_DOWN: {
                    return "_sideways";
                }
            }
            return "_sideways_inverted";
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

