/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class TurretRenderer
extends TileEntityRenderer<TurretTileEntity> {
    public TurretRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TurretTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.isDummy() || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = tile.func_174877_v();
        BlockState state = tile.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.MetalDevices.turretChem && state.func_177230_c() != IEBlocks.MetalDevices.turretGun) {
            return;
        }
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), tile.rotationYaw, true));
        matrixStack.func_227863_a_(new Quaternion(new Vector3f((float)tile.getFacing().func_82599_e(), 0.0f, (float)(-tile.getFacing().func_82601_c())), tile.rotationPitch, true));
        TurretRenderer.renderModelPart(bufferIn, matrixStack, tile.getWorldNonnull(), state, model, tile.func_174877_v(), true, combinedLightIn, "gun");
        if (tile instanceof TurretGunTileEntity) {
            if (((TurretGunTileEntity)tile).cycleRender > 0) {
                float cycle = 0.0f;
                cycle = ((TurretGunTileEntity)tile).cycleRender > 3 ? (float)(5 - ((TurretGunTileEntity)tile).cycleRender) / 2.0f : (float)((TurretGunTileEntity)tile).cycleRender / 3.0f;
                matrixStack.func_227861_a_((double)((float)(-tile.getFacing().func_82601_c()) * cycle) * 0.3125, 0.0, (double)((float)(-tile.getFacing().func_82599_e()) * cycle) * 0.3125);
            }
            TurretRenderer.renderModelPart(bufferIn, matrixStack, tile.getWorldNonnull(), state, model, tile.func_174877_v(), false, combinedLightIn, "action");
        }
        matrixStack.func_227865_b_();
    }

    public static void renderModelPart(IRenderTypeBuffer buffer, MatrixStack matrix, World world, BlockState state, IBakedModel model, BlockPos pos, boolean isFirst, int light, String ... parts) {
        pos = pos.func_177984_a();
        IVertexBuilder solidBuilder = buffer.getBuffer(RenderType.func_228639_c_());
        matrix.func_227860_a_();
        matrix.func_227861_a_(-0.5, 0.0, -0.5);
        List quads = model.getQuads(state, null, Utils.RAND, new SinglePropertyModelData<IEProperties.IEObjState>(new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts)), IEProperties.Model.IE_OBJ_STATE));
        RenderUtils.renderModelTESRFancy(quads, new TransformingVertexBuilder(solidBuilder, matrix), world, pos, !isFirst, -1, light);
        matrix.func_227865_b_();
    }
}

