/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

public class ModelConfigurableSides
extends BakedIEModel {
    private static HashMap<String, ITextureNamer> TYPES = new HashMap();
    private final LoadingCache<Map<Direction, IEEnums.IOSideConfig>, Map<Direction, BakedQuad>> modelCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        EnumMap<Direction, TextureAtlasSprite> tex = new EnumMap<Direction, TextureAtlasSprite>(Direction.class);
        for (Direction d : DirectionUtils.VALUES) {
            tex.put(d, this.textures.get(d).get(key.get(d)));
        }
        return ModelConfigurableSides.bakeQuads(tex);
    }));
    public Map<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> textures;
    static final ItemCameraTransforms defaultTransforms;

    public ModelConfigurableSides(Map<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> textures) {
        this.textures = textures;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        EnumMap<Direction, IEEnums.IOSideConfig> config;
        if (side == null) {
            return ImmutableList.of();
        }
        if (extraData.hasProperty(IEProperties.Model.SIDECONFIG)) {
            config = (EnumMap<Direction, IEEnums.IOSideConfig>)extraData.getData(IEProperties.Model.SIDECONFIG);
        } else {
            config = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                config.put(d, IEEnums.IOSideConfig.NONE);
            }
        }
        assert (config != null);
        return ImmutableList.of((Object)((BakedQuad)((Map)this.modelCache.getUnchecked(config)).get(side)));
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ArrayList<IModelData> data = new ArrayList<IModelData>();
        data.add(tileData);
        data.add(super.getModelData(world, pos, state, tileData));
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IConfigurableSides) {
            IEBlockInterfaces.IConfigurableSides confTE = (IEBlockInterfaces.IConfigurableSides)te;
            EnumMap<Direction, IEEnums.IOSideConfig> conf = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                conf.put(d, confTE.getSideConfig(d));
            }
            data.add(new SinglePropertyModelData<Map<Direction, IEEnums.IOSideConfig>>(conf, IEProperties.Model.SIDECONFIG));
        }
        return CombinedModelData.combine(data.toArray(new IModelData[0]));
    }

    private static Map<Direction, BakedQuad> bakeQuads(Map<Direction, TextureAtlasSprite> sprites) {
        EnumMap<Direction, BakedQuad> quads = new EnumMap<Direction, BakedQuad>(Direction.class);
        Vector3d[] vertices = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(1.0, 0.0, 1.0), new Vector3d(1.0, 0.0, 0.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.DOWN, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vector3d[]{new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 1.0, 1.0), new Vector3d(1.0, 1.0, 1.0), new Vector3d(1.0, 1.0, 0.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.UP, vertices, new double[]{0.0, 0.0, 16.0, 16.0});
        vertices = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(1.0, 1.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, 0.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.NORTH, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vector3d[]{new Vector3d(1.0, 0.0, 1.0), new Vector3d(1.0, 1.0, 1.0), new Vector3d(0.0, 1.0, 1.0), new Vector3d(0.0, 0.0, 1.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.SOUTH, vertices, new double[]{16.0, 16.0, 0.0, 0.0});
        vertices = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 1.0, 1.0), new Vector3d(0.0, 0.0, 1.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.WEST, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(1.0, 1.0, 0.0), new Vector3d(1.0, 1.0, 1.0), new Vector3d(1.0, 0.0, 1.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.EAST, vertices, new double[]{16.0, 16.0, 0.0, 0.0});
        return quads;
    }

    private static void addQuad(Map<Direction, BakedQuad> out, Map<Direction, TextureAtlasSprite> sprites, Direction side, Vector3d[] vertices, double[] uv) {
        out.put(side, ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, side, sprites.get(side), uv, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, side.func_176743_c() == Direction.AxisDirection.NEGATIVE));
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.textures.get(Direction.DOWN).get((Object)IEEnums.IOSideConfig.NONE);
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return defaultTransforms;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    static {
        for (Type type : Type.values()) {
            TYPES.put(type.getName(), type.nameMapper);
        }
        defaultTransforms = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.25f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));
    }

    public static enum Type {
        SIDE_TOP_BOTTOM(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? side.func_176610_l() : "side";
            }
        }),
        SIDE_VERTICAL(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? "up" : "side";
            }
        }),
        VERTICAL(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? "up" : "side";
            }

            @Override
            public String nameFromCfg(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? cfg.getTextureName() : null;
            }
        }),
        ALL_SAME_TEXTURE(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return "side";
            }
        });

        private final ITextureNamer nameMapper;

        private Type(ITextureNamer nameMapper) {
            this.nameMapper = nameMapper;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static interface ITextureNamer {
        default public String getTextureName(Direction side, IEEnums.IOSideConfig cfg) {
            String s = this.nameFromSide(side, cfg);
            String c = this.nameFromCfg(side, cfg);
            if (s != null && c != null) {
                return s + "_" + c;
            }
            if (s != null) {
                return s;
            }
            if (c != null) {
                return c;
            }
            return "";
        }

        default public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
            return side.func_176610_l();
        }

        default public String nameFromCfg(Direction side, IEEnums.IOSideConfig cfg) {
            return cfg.getTextureName();
        }
    }

    private static class ConfigSidesModelBase
    implements IModelGeometry<ConfigSidesModelBase> {
        final String type;
        Map<String, RenderMaterial> textures;

        public ConfigSidesModelBase(String type, Map<String, RenderMaterial> textures) {
            this.type = type;
            this.textures = textures;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            EnumMap<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> tex = new EnumMap<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>>(Direction.class);
            for (Direction f : DirectionUtils.VALUES) {
                EnumMap<IEEnums.IOSideConfig, TextureAtlasSprite> forSide = new EnumMap<IEEnums.IOSideConfig, TextureAtlasSprite>(IEEnums.IOSideConfig.class);
                for (IEEnums.IOSideConfig cfg : IEEnums.IOSideConfig.values()) {
                    RenderMaterial rl = this.textures.get(f.func_176610_l() + "_" + cfg.getTextureName());
                    if (rl == null) continue;
                    forSide.put(cfg, spriteGetter.apply(rl));
                }
                tex.put(f, forSide);
            }
            return new ModelConfigurableSides(tex);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.textures.values();
        }
    }

    public static class Loader
    implements IModelLoader<ConfigSidesModelBase> {
        public static ResourceLocation NAME = new ResourceLocation("immersiveengineering", "conf_sides");

        public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
            if (resourcePredicate.test((IResourceType)VanillaResourceType.MODELS) || resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
                this.func_195410_a(resourceManager);
            }
        }

        @Nonnull
        public ConfigSidesModelBase read(@Nonnull JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            String name = modelContents.get("base_name").getAsString();
            String type = modelContents.get("type").getAsString();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ITextureNamer namer = (ITextureNamer)TYPES.get(type);
            for (Direction f : DirectionUtils.VALUES) {
                for (IEEnums.IOSideConfig cfg : IEEnums.IOSideConfig.values()) {
                    String key = f.func_176610_l() + "_" + cfg.getTextureName();
                    String tex = name + "_" + namer.getTextureName(f, cfg);
                    builder.put((Object)key, (Object)new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation(tex)));
                }
            }
            return new ConfigSidesModelBase(type, (Map<String, RenderMaterial>)builder.build());
        }
    }
}

