/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;

public class SqueezerRecipe
extends MultiblockRecipe {
    public static IRecipeType<SqueezerRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<SqueezerRecipe>> SERIALIZER;
    public IngredientWithSize input;
    public final FluidStack fluidOutput;
    @Nonnull
    public final ItemStack itemOutput;
    public static Map<ResourceLocation, SqueezerRecipe> recipeList;

    public SqueezerRecipe(ResourceLocation id, FluidStack fluidOutput, @Nonnull ItemStack itemOutput, IngredientWithSize input, int energy) {
        super(itemOutput, TYPE, id);
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.input = input;
        this.setTimeAndEnergy(80, energy);
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.itemOutput});
    }

    @Override
    protected IERecipeSerializer<SqueezerRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public SqueezerRecipe setInputSize(int size) {
        this.input = this.input.withSize(size);
        return this;
    }

    public static SqueezerRecipe findRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        for (SqueezerRecipe recipe : recipeList.values()) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public static SortedMap<ITextComponent, Integer> getFluidValuesSorted(Fluid f, boolean inverse) {
        TreeMap<ITextComponent, Integer> map = new TreeMap<ITextComponent, Integer>(Comparator.comparing(ITextComponent::getString, inverse ? Comparator.reverseOrder() : Comparator.naturalOrder()));
        for (SqueezerRecipe recipe : recipeList.values()) {
            if (recipe.fluidOutput == null || recipe.fluidOutput.getFluid() != f || recipe.input.hasNoMatchingItems()) continue;
            ItemStack is = recipe.input.getMatchingStacks()[0];
            map.put(is.func_200301_q(), recipe.fluidOutput.getAmount());
        }
        return map;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

