/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public interface ClocheRenderFunction {
    public static final Map<String, ClocheRenderFunctionFactory> RENDER_FUNCTION_FACTORIES = new HashMap<String, ClocheRenderFunctionFactory>();

    public float getScale(ItemStack var1, float var2);

    public Collection<Pair<BlockState, TransformationMatrix>> getBlocks(ItemStack var1, float var2);

    default public void injectQuads(ItemStack stack, float growth, Consumer<?> quadConsumer) {
    }

    public static class ClocheRenderReference {
        private final String type;
        private final Block block;

        public ClocheRenderReference(String type, Block block) {
            this.type = type;
            this.block = block;
        }

        public String getType() {
            return this.type;
        }

        public Block getBlock() {
            return this.block;
        }

        public void write(PacketBuffer buffer) {
            buffer.func_180714_a(this.getType());
            buffer.func_192572_a(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.getBlock()));
        }

        public static ClocheRenderReference read(PacketBuffer buffer) {
            String key = buffer.func_218666_n();
            ResourceLocation rl = buffer.func_192575_l();
            return new ClocheRenderReference(key, (Block)ForgeRegistries.BLOCKS.getValue(rl));
        }

        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", this.getType());
            jsonObject.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.getBlock()).toString());
            return jsonObject;
        }

        public static ClocheRenderReference deserialize(JsonObject jsonObject) {
            String key = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type");
            ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"block"));
            return new ClocheRenderReference(key, (Block)ForgeRegistries.BLOCKS.getValue(rl));
        }
    }

    public static interface ClocheRenderFunctionFactory
    extends Function<Block, ClocheRenderFunction> {
    }
}

