/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.util.IItemProvider;

public class CustomRecipeBuilder {
    Consumer<IFinishedRecipe> consumer;
    IItemProvider BlockItem;
    private final HashMap<IItemProvider, Character> definitionLookup = new HashMap();
    private final List<List<IItemProvider>> Rows = new ArrayList<List<IItemProvider>>();
    private IItemProvider UnlockedBy;
    private final Random r = new Random();
    private final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public CustomRecipeBuilder(Consumer<IFinishedRecipe> consumer, IItemProvider BlockItem2) {
        this.consumer = consumer;
        this.BlockItem = BlockItem2;
    }

    public CustomRecipeBuilder UnlockedBy(IItemProvider unlockedBy) {
        this.UnlockedBy = unlockedBy;
        return this;
    }

    public CustomRecipeBuilder Row(@Nullable IItemProvider item1, @Nullable IItemProvider item2, @Nullable IItemProvider item3) {
        ArrayList<IItemProvider> row = new ArrayList<IItemProvider>(3);
        this.Rows.add(row);
        this.AddItem(row, item1);
        this.AddItem(row, item2);
        this.AddItem(row, item3);
        return this;
    }

    public CustomRecipeBuilder Row(@Nullable IItemProvider item1, @Nullable IItemProvider item2) {
        ArrayList<IItemProvider> row = new ArrayList<IItemProvider>(2);
        this.Rows.add(row);
        this.AddItem(row, item1);
        this.AddItem(row, item2);
        return this;
    }

    public CustomRecipeBuilder Row(@Nullable IItemProvider item1) {
        ArrayList<IItemProvider> row = new ArrayList<IItemProvider>(1);
        this.Rows.add(row);
        this.AddItem(row, item1);
        return this;
    }

    private void AddItem(ArrayList<IItemProvider> row, IItemProvider item) {
        row.add(item);
        if (item != null && !this.definitionLookup.containsKey(item)) {
            boolean flag = true;
            while (flag) {
                char letter = this.RandomLetter();
                if (this.definitionLookup.containsValue(Character.valueOf(letter))) continue;
                flag = false;
                this.definitionLookup.put(item, Character.valueOf(letter));
            }
        }
    }

    public void Save() {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.func_200470_a((IItemProvider)this.BlockItem);
        for (List<IItemProvider> list : this.Rows) {
            String pattern = list.stream().map(i -> i == null ? " " : this.definitionLookup.get(i).toString()).collect(Collectors.joining());
            builder.func_200472_a(pattern);
        }
        for (Map.Entry entry : this.definitionLookup.entrySet()) {
            builder.func_200462_a((Character)entry.getValue(), (IItemProvider)entry.getKey());
        }
        builder.func_200465_a(this.UnlockedBy.toString(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{this.UnlockedBy}));
        builder.func_200464_a(this.consumer);
    }

    private char RandomLetter() {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(this.r.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZ".length()));
    }
}

