/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.network;

import com.vice.balancedflight.network.BalancedFlightNetwork;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CustomNetworkMessage {
    private final UUID player;
    private final String message;

    public CustomNetworkMessage(PacketBuffer buffer) {
        this.player = buffer.func_179253_g();
        this.message = buffer.func_150789_c(Short.MAX_VALUE);
    }

    public CustomNetworkMessage(UUID player, String message) {
        this.player = player;
        this.message = message;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.player);
        buf.func_180714_a(this.message);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if ("FIRE_ROCKET".equals(this.message)) {
                CustomNetworkMessage.FireRocket(this.player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void Send(World world, PlayerEntity player, String message) {
        if (world.field_72995_K) {
            BalancedFlightNetwork.INSTANCE.sendToServer((Object)new CustomNetworkMessage(player.func_146103_bH().getId(), message));
        }
        if (!world.field_72995_K) {
            BalancedFlightNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CustomNetworkMessage(player.func_146103_bH().getId(), "FIRE_ROCKET"));
        }
    }

    private static void FireRocket(UUID uuid) {
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            return;
        }
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196152_dE, 64);
        player.field_70170_p.func_217376_c((Entity)new FireworkRocketEntity(player.field_70170_p, itemstack, (LivingEntity)player));
    }
}

