/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.items;

import com.tterrag.balancedflight.repack.registrate.Registrate;
import com.tterrag.balancedflight.repack.registrate.builders.ItemBuilder;
import com.tterrag.balancedflight.repack.registrate.util.entry.RegistryEntry;
import com.vice.balancedflight.BalancedFlight;
import com.vice.balancedflight.Registry;
import com.vice.balancedflight.compat.CuriosCompat;
import com.vice.balancedflight.compat.ExternalMods;
import com.vice.balancedflight.util.ModItemTab;
import com.vice.balancedflight.util.RecipeHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

@Mod.EventBusSubscriber(modid="balancedflight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FlightRing
extends Item {
    public final FlightRingType tier;
    public static final RegistryEntry<? extends Item> ASCENDED = FlightRing.RegCommon(FlightRingType.ASCENDED).recipe((gen, prov) -> RecipeHelper.Shaped(prov, (IItemProvider)gen.get()).Row((IItemProvider)Registry.FLIGHT_CORE.get(), (IItemProvider)Items.field_221696_bj, (IItemProvider)Registry.FLIGHT_CORE.get()).Row((IItemProvider)Items.field_221696_bj, (IItemProvider)Items.field_185160_cR, (IItemProvider)Items.field_221696_bj).Row((IItemProvider)Registry.FLIGHT_CORE.get(), (IItemProvider)Items.field_221696_bj, (IItemProvider)Registry.FLIGHT_CORE.get()).UnlockedBy((IItemProvider)Items.field_151008_G).Save()).register();
    public static final RegistryEntry<? extends Item> BASIC = FlightRing.RegCommon(FlightRingType.BASIC).recipe((gen, prov) -> RecipeHelper.Shaped(prov, (IItemProvider)gen.get()).Row((IItemProvider)Items.field_151042_j, (IItemProvider)Items.field_221866_eq, (IItemProvider)Items.field_151042_j).Row((IItemProvider)Items.field_221866_eq, (IItemProvider)Items.field_151008_G, (IItemProvider)Items.field_221866_eq).Row((IItemProvider)Items.field_151042_j, (IItemProvider)Items.field_221866_eq, (IItemProvider)Items.field_151042_j).UnlockedBy((IItemProvider)Items.field_151008_G).Save()).register();

    public FlightRing(Item.Properties props, FlightRingType tier) {
        super(props);
        this.tier = tier;
    }

    public static final ItemBuilder<FlightRing, Registrate> RegCommon(FlightRingType ringtier) {
        return BalancedFlight.registrate().item(ringtier.getResourceName(), p -> new FlightRing((Item.Properties)p, ringtier)).initialProperties(() -> new Item.Properties().func_200917_a(1).func_200916_a(ModItemTab.tab));
    }

    @SubscribeEvent
    public static void sendImc(InterModEnqueueEvent event) {
        if (ExternalMods.CURIOS.isLoaded()) {
            CuriosCompat.sendImc();
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT unused) {
        if (ExternalMods.CURIOS.isLoaded()) {
            return CuriosCompat.initCapabilities((FlightRing)stack.func_77973_b());
        }
        return super.initCapabilities(stack, unused);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (((FlightRing)stack.func_77973_b()).tier == FlightRingType.ASCENDED) {
            tooltip.add((ITextComponent)new StringTextComponent("An incredibly dense golden ring. Despite its weight, it allows you to fly anywhere (Angel Ring).").func_240699_a_(TextFormatting.GOLD));
            tooltip.add((ITextComponent)new StringTextComponent("Allows both creative and enhanced Elytra flight.").func_240699_a_(TextFormatting.WHITE));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("Cheap ring that allows flight around flight anchors (Angel Ring).").func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)new StringTextComponent("Allows both creative and enhanced Elytra flight.").func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)new StringTextComponent("Only works in the overworld.").func_240699_a_(TextFormatting.RED));
        }
    }

    public static enum FlightRingType implements IStringSerializable
    {
        BASIC("basic"),
        ASCENDED("ascended");

        private final String name;

        private FlightRingType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getResourceName() {
            return this.name + "_flight_ring";
        }
    }
}

