/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.vice.balancedflight.config.ConfigBuilder;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    public static ForgeConfigSpec ConfigSpec;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableElytraFlightFromGround;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableTakeOff;
    public static ForgeConfigSpec.ConfigValue<Boolean> infiniteRockets;
    public static ForgeConfigSpec.ConfigValue<Boolean> ElytraBasic;
    public static ForgeConfigSpec.ConfigValue<Boolean> ElytraAscended;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableFallDamageWithRings;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableElytraDamageWithRings;
    public static ForgeConfigSpec.ConfigValue<Boolean> CreativeBasic;
    public static ForgeConfigSpec.ConfigValue<Boolean> CreativeAscended;
    public static ForgeConfigSpec.ConfigValue<Double> anchorDistanceMultiplier;

    public static void init() {
        if (ConfigSpec.isLoaded()) {
            return;
        }
        Config.loadConfig(FMLPaths.CONFIGDIR.get().resolve("balanced_flight.toml"));
    }

    private static void loadConfig(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        ConfigSpec.setConfig((CommentedConfig)configData);
    }

    static {
        ConfigBuilder builder = new ConfigBuilder("Balanced Flight Settings");
        builder.Block("Flight Options", b -> {
            CreativeAscended = b.define("Ascended Ring Gives Unlimited Creative Flight (will fall back to Basic tier inside range)", true);
            ElytraAscended = b.define("Ascended Ring Also Works As Elytra", true);
            CreativeBasic = b.define("Basic Ring Gives Creative Flight", true);
            ElytraBasic = b.define("Basic Flight Ring Also Works As Elytra", false);
        });
        builder.Block("Balancing Config", b -> {
            anchorDistanceMultiplier = b.defineInRange("Anchor Distance Multiplier (0->10)", 1.0, 0.0, 10.0);
            disableFallDamageWithRings = b.define("Disable Fall Damage When Wearing Rings", true);
            disableElytraDamageWithRings = b.define("Disable Elytra Damage When Wearing Rings", true);
        });
        builder.Block("Enhanced Elytra Mechanics", b -> {
            enableElytraFlightFromGround = b.define("Enable Elytra Flight From Ground", true);
            enableTakeOff = b.define("Enable Take Off Mechanic", true);
            infiniteRockets = b.define("Infinite Rockets", true);
        });
        ConfigSpec = builder.Save();
    }
}

