/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.compat;

import com.vice.balancedflight.blocks.FlightAnchorEntity;
import com.vice.balancedflight.config.Config;
import com.vice.balancedflight.items.FlightRing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat
implements ICurio {
    private final FlightRing parent;

    public CuriosCompat(FlightRing parent) {
        this.parent = parent;
    }

    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("flight_ring").build());
    }

    public static ICapabilityProvider initCapabilities(FlightRing stack) {
        final CuriosCompat curio = new CuriosCompat(stack);
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack) {
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        LivingEntity livingEntity = slotContext.getWearer();
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            this.stopFlying(player);
        }
    }

    private void startFlying(PlayerEntity player) {
        if (!player.func_184812_l_() && !player.func_175149_v()) {
            player.field_71075_bZ.field_75101_c = true;
            player.func_71016_p();
        }
    }

    private void stopFlying(PlayerEntity player) {
        if (!player.func_184812_l_() && !player.func_175149_v()) {
            player.field_71075_bZ.field_75100_b = false;
            player.field_71075_bZ.field_75101_c = false;
            player.func_71016_p();
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        FlightMode allowed = CuriosCompat.AllowedFlightModes(player, false);
        if (allowed == FlightMode.None || allowed == FlightMode.Elytra) {
            if (!player.func_184812_l_() && player.field_71075_bZ.field_75101_c) {
                this.stopFlying(player);
                player.func_195064_c(new EffectInstance(Effects.field_204839_B, 200));
            }
        } else if (!player.field_71075_bZ.field_75101_c) {
            this.startFlying(player);
            if (player.func_70644_a(Effects.field_204839_B)) {
                player.func_195063_d(Effects.field_204839_B);
            }
        }
    }

    public static FlightMode AllowedFlightModes(PlayerEntity player, boolean onlyCareAboutElytra) {
        boolean hasAscended = CuriosCompat.HasAscendedRing(player);
        boolean hasBasic = CuriosCompat.HasBasicRing(player);
        if (!hasAscended && !hasBasic) {
            return FlightMode.None;
        }
        if (hasAscended) {
            boolean CanCreativeFly;
            boolean CanElytraFly = (Boolean)Config.ElytraAscended.get();
            FlightMode allowedModes = FlightMode.fromBools(CanElytraFly, CanCreativeFly = ((Boolean)Config.CreativeAscended.get()).booleanValue());
            if (allowedModes != FlightMode.Elytra) {
                return allowedModes;
            }
            if (!CanCreativeFly && ((Boolean)Config.CreativeBasic.get()).booleanValue() && CuriosCompat.IsWithinFlightRange(player)) {
                return FlightMode.fromBools(CanElytraFly, true);
            }
            return allowedModes;
        }
        boolean CanElytraFly = (Boolean)Config.ElytraBasic.get();
        boolean CanCreativeFly = (Boolean)Config.CreativeBasic.get();
        if (onlyCareAboutElytra && !CanElytraFly) {
            return FlightMode.None;
        }
        if (CuriosCompat.IsWithinFlightRange(player)) {
            return FlightMode.fromBools(CanElytraFly, CanCreativeFly);
        }
        return FlightMode.None;
    }

    private static boolean HasAnyRing(PlayerEntity player) {
        return CuriosCompat.HasBasicRing(player) || CuriosCompat.HasAscendedRing(player);
    }

    private static boolean HasBasicRing(PlayerEntity player) {
        return CuriosCompat.isRingInCuriosSlot(FlightRing.BASIC.get(), (LivingEntity)player);
    }

    private static boolean HasAscendedRing(PlayerEntity player) {
        return CuriosCompat.isRingInCuriosSlot(FlightRing.ASCENDED.get(), (LivingEntity)player);
    }

    private static boolean IsWithinFlightRange(PlayerEntity player) {
        if (player.field_70170_p.func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        double anchorDistanceMultiplier = (Double)Config.anchorDistanceMultiplier.get();
        return FlightAnchorEntity.ActiveAnchors.stream().anyMatch(anchor -> CuriosCompat.distSqr((Vector3i)anchor.position, player.func_213303_ch()) < anchorDistanceMultiplier * anchor.tier.EffectDistance * (anchorDistanceMultiplier * anchor.tier.EffectDistance));
    }

    private static double distSqr(Vector3i vec, Vector3d other) {
        double d1 = (double)vec.func_177958_n() - other.field_72450_a;
        double d3 = (double)vec.func_177952_p() - other.field_72449_c;
        return d1 * d1 + d3 * d3;
    }

    public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
        return !CuriosCompat.HasAnyRing((PlayerEntity)entityLivingBase);
    }

    public static boolean isRingInCuriosSlot(Item balancedflight, LivingEntity player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(balancedflight, player).isPresent();
    }

    public void playRightClickEquipSound(LivingEntity entityLivingBase) {
        entityLivingBase.func_184185_a(SoundEvents.field_191258_p, 1.0f, 1.0f);
    }

    public boolean showAttributesTooltip(String identifier) {
        return true;
    }

    public static enum FlightMode {
        None,
        Elytra,
        Creative,
        Both;


        public static FlightMode fromBools(boolean ElytraAllowed, boolean CreativeAllowed) {
            if (ElytraAllowed && CreativeAllowed) {
                return Both;
            }
            if (ElytraAllowed) {
                return Elytra;
            }
            if (CreativeAllowed) {
                return Creative;
            }
            return None;
        }

        public boolean canElytraFly() {
            return this == Elytra || this == Both;
        }

        public boolean canCreativeFly() {
            return this == Creative || this == Both;
        }
    }
}

