/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.blocks;

import com.tterrag.balancedflight.repack.registrate.Registrate;
import com.tterrag.balancedflight.repack.registrate.builders.BlockBuilder;
import com.tterrag.balancedflight.repack.registrate.builders.ItemBuilder;
import com.tterrag.balancedflight.repack.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.balancedflight.repack.registrate.util.entry.RegistryEntry;
import com.vice.balancedflight.BalancedFlight;
import com.vice.balancedflight.Registry;
import com.vice.balancedflight.blocks.AnchorItem;
import com.vice.balancedflight.blocks.FlightAnchorEntity;
import com.vice.balancedflight.util.RecipeHelper;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="balancedflight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlightAnchor
extends Block {
    public static final RegistryEntry<? extends Block> BASIC = ((BlockBuilder)FlightAnchor.FlightAnchorCommon("basic", "(Basic)", AnchorTier.BASIC).recipe((gen, provider) -> RecipeHelper.Shaped(provider, (IItemProvider)gen.get()).Row((IItemProvider)Items.field_234785_rI_, (IItemProvider)Items.field_221696_bj, (IItemProvider)Items.field_234785_rI_).Row((IItemProvider)Items.field_221698_bk, (IItemProvider)Items.field_151008_G, (IItemProvider)Items.field_221698_bk).Row((IItemProvider)Items.field_234785_rI_, (IItemProvider)Items.field_234785_rI_, (IItemProvider)Items.field_234785_rI_).UnlockedBy((IItemProvider)Items.field_151008_G).Save()).build()).register();
    public static final RegistryEntry<? extends Block> GILDED = ((BlockBuilder)FlightAnchor.FlightAnchorCommon("gilded", "(Gilded)", AnchorTier.GILDED).recipe((gen, provider) -> RecipeHelper.Shaped(provider, (IItemProvider)gen.get()).Row((IItemProvider)Items.field_234785_rI_, (IItemProvider)Items.field_221732_cb, (IItemProvider)Items.field_234785_rI_).Row((IItemProvider)Items.field_221696_bj, (IItemProvider)Items.field_151008_G, (IItemProvider)Items.field_221696_bj).Row((IItemProvider)Registry.ASCENDED_BLACKSTONE.get(), (IItemProvider)BASIC.get(), (IItemProvider)Registry.ASCENDED_BLACKSTONE.get()).UnlockedBy((IItemProvider)Items.field_151008_G).Save()).build()).register();
    public static final RegistryEntry<? extends Block> ASCENDED = ((BlockBuilder)FlightAnchor.FlightAnchorCommon("ascended", "(Ascended)", AnchorTier.ASCENDED).recipe((gen, provider) -> RecipeHelper.Shaped(provider, (IItemProvider)gen.get()).Row((IItemProvider)Registry.ASCENDED_BLACKSTONE.get(), (IItemProvider)Items.field_221739_dF, (IItemProvider)Registry.ASCENDED_BLACKSTONE.get()).Row((IItemProvider)Items.field_221732_cb, (IItemProvider)Items.field_151008_G, (IItemProvider)Items.field_221732_cb).Row((IItemProvider)Registry.ASCENDED_BLACKSTONE.get(), (IItemProvider)GILDED.get(), (IItemProvider)Registry.ASCENDED_BLACKSTONE.get()).UnlockedBy((IItemProvider)Items.field_151008_G).Save()).build()).register();
    public static EnumProperty<AnchorTier> TIER = EnumProperty.func_177709_a((String)"tier", AnchorTier.class);

    public FlightAnchor(AbstractBlock.Properties p_i48440_1_, AnchorTier tier) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TIER, (Comparable)((Object)tier)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TIER});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FlightAnchorEntity((TileEntityType)FlightAnchorEntity.REGISTRATION.get());
    }

    private static ItemBuilder<AnchorItem, BlockBuilder<FlightAnchor, Registrate>> FlightAnchorCommon(String prefix, String langtag, AnchorTier tier) {
        return ((Registrate)BalancedFlight.registrate().object(tier.func_176610_l() + "_flight_anchor")).block(props -> new FlightAnchor((AbstractBlock.Properties)props, tier)).blockstate((gen, provider) -> provider.getVariantBuilder((Block)gen.get()).forAllStates(state -> {
            BlockModelBuilder models = FlightAnchor.getModelFileForVariant((AnchorTier)((Object)((Object)((Object)state.func_177229_b(TIER)))), provider);
            return ConfiguredModel.builder().modelFile((ModelFile)models).build();
        })).properties(properties -> AbstractBlock.Properties.func_200945_a((Material)Material.field_151574_g).harvestTool(ToolType.PICKAXE).func_200943_b(100.0f).func_200947_a(SoundType.field_235594_P_)).defaultLoot().item((block, props) -> new AnchorItem(tier, (Block)block, (Item.Properties)props)).initialProperties(() -> new Item.Properties().func_200917_a(1)).model((ctx, prov) -> prov.withExistingParent("item/" + prov.name(ctx::getEntry), new ResourceLocation(prov.modid(ctx::getEntry), "block/" + prov.name(ctx::getEntry))));
    }

    private static BlockModelBuilder getModelFileForVariant(AnchorTier tier, RegistrateBlockstateProvider provider) {
        return (BlockModelBuilder)provider.models().cubeBottomTop(tier.func_176610_l() + "_flight_anchor", provider.modLoc("block/" + tier.getResourceName("side")), provider.modLoc("block/" + tier.getResourceName("bottom")), provider.modLoc("block/" + tier.getResourceName("top")));
    }

    public static enum AnchorTier implements IStringSerializable
    {
        BASIC("basic", 25.0),
        GILDED("gilded", 50.0),
        ASCENDED("ascended", 100.0);

        public final double EffectDistance;
        private final String name;

        private AnchorTier(String name, double effectDistance) {
            this.name = name;
            this.EffectDistance = effectDistance;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getResourceName(String side) {
            return this.name + "_flight_anchor_" + side;
        }
    }
}

