/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.balancedflight.repack.registrate.providers;

import com.tterrag.balancedflight.repack.registrate.AbstractRegistrate;
import com.tterrag.balancedflight.repack.registrate.providers.ProviderType;
import com.tterrag.balancedflight.repack.registrate.providers.RegistrateProvider;
import com.tterrag.balancedflight.repack.registrate.util.nullness.NonNullSupplier;
import com.tterrag.balancedflight.repack.registrate.util.nullness.NonnullType;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class RegistrateLangProvider
extends LanguageProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> owner;
    private final AccessibleLanguageProvider upsideDown;
    private static final String NORMAL_CHARS = "abcdefghijklmn\u00f1opqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = "\u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";

    public RegistrateLangProvider(AbstractRegistrate<?> owner, DataGenerator gen) {
        super(gen, owner.getModid(), "en_us");
        this.owner = owner;
        this.upsideDown = new AccessibleLanguageProvider(gen, owner.getModid(), "en_ud");
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.CLIENT;
    }

    public String func_200397_b() {
        return "Lang (en_us/en_ud)";
    }

    protected void addTranslations() {
        this.owner.genData(ProviderType.LANG, this);
    }

    public static final String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public String getAutomaticName(NonNullSupplier<? extends IForgeRegistryEntry<?>> sup) {
        return RegistrateLangProvider.toEnglishName(sup.get().getRegistryName().func_110623_a());
    }

    public void addBlock(NonNullSupplier<? extends Block> block) {
        this.addBlock(block, this.getAutomaticName(block));
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends Block> block, String tooltip) {
        this.addBlock(block);
        this.addTooltip(block, tooltip);
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends Block> block, String name, String tooltip) {
        this.addBlock(block, name);
        this.addTooltip(block, tooltip);
    }

    public void addItem(NonNullSupplier<? extends Item> item) {
        this.addItem(item, this.getAutomaticName(item));
    }

    public void addItemWithTooltip(NonNullSupplier<? extends Item> block, String name, List<@NonnullType String> tooltip) {
        this.addItem(block, name);
        this.addTooltip(block, tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends IItemProvider> item, String tooltip) {
        this.add(item.get().func_199767_j().func_77658_a() + ".desc", tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends IItemProvider> item, List<@NonnullType String> tooltip) {
        for (int i = 0; i < tooltip.size(); ++i) {
            this.add(item.get().func_199767_j().func_77658_a() + ".desc." + i, tooltip.get(i));
        }
    }

    public void add(ItemGroup group, String name) {
        this.add(((TranslationTextComponent)group.func_242392_c()).func_150268_i(), name);
    }

    public void addEntityType(NonNullSupplier<? extends EntityType<?>> entity) {
        this.addEntityType(entity, this.getAutomaticName(entity));
    }

    private String toUpsideDown(String normal) {
        char[] ud = new char[normal.length()];
        for (int i = 0; i < normal.length(); ++i) {
            char c = normal.charAt(i);
            if (c == '%') {
                String fmtArg = "";
                while (Character.isDigit(c) || c == '%' || c == '$' || c == 's' || c == 'd') {
                    fmtArg = fmtArg + c;
                    c = ++i == normal.length() ? (char)'\u0000' : normal.charAt(i);
                }
                --i;
                for (int j = 0; j < fmtArg.length(); ++j) {
                    ud[normal.length() - 1 - i + j] = fmtArg.charAt(j);
                }
                continue;
            }
            int lookup = NORMAL_CHARS.indexOf(c);
            if (lookup >= 0) {
                c = UPSIDE_DOWN_CHARS.charAt(lookup);
            }
            ud[normal.length() - 1 - i] = c;
        }
        return new String(ud);
    }

    public void add(String key, String value) {
        super.add(key, value);
        this.upsideDown.add(key, this.toUpsideDown(value));
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        super.func_200398_a(cache);
        this.upsideDown.func_200398_a(cache);
    }

    static {
        if (NORMAL_CHARS.length() != UPSIDE_DOWN_CHARS.length()) {
            throw new AssertionError((Object)"Char maps do not match in length!");
        }
    }

    private static class AccessibleLanguageProvider
    extends LanguageProvider {
        public AccessibleLanguageProvider(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        public void add(@Nullable String key, @Nullable String value) {
            super.add(key, value);
        }

        protected void addTranslations() {
        }
    }
}

