/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.balancedflight.repack.registrate.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.tterrag.balancedflight.repack.registrate.AbstractRegistrate;
import com.tterrag.balancedflight.repack.registrate.providers.ProviderType;
import com.tterrag.balancedflight.repack.registrate.providers.RegistrateProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrateAdvancementProvider
implements RegistrateProvider,
Consumer<Advancement> {
    private static final Logger log = LogManager.getLogger(RegistrateAdvancementProvider.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final AbstractRegistrate<?> owner;
    private final DataGenerator generator;
    @Nullable
    private DirectoryCache cache;
    private Set<ResourceLocation> seenAdvancements = new HashSet<ResourceLocation>();

    public RegistrateAdvancementProvider(AbstractRegistrate<?> owner, DataGenerator generatorIn) {
        this.owner = owner;
        this.generator = generatorIn;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    public TranslationTextComponent title(String category, String name, String title) {
        return this.owner.addLang("advancements", new ResourceLocation(category, name), "title", title);
    }

    public TranslationTextComponent desc(String category, String name, String desc) {
        return this.owner.addLang("advancements", new ResourceLocation(category, name), "description", desc);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        try {
            this.cache = cache;
            this.seenAdvancements.clear();
            this.owner.genData(ProviderType.ADVANCEMENT, this);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public void accept(@Nullable Advancement t) {
        DirectoryCache cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cannot accept advancements outside of act");
        }
        Objects.requireNonNull(t, "Cannot accept a null advancement");
        Path path = this.generator.func_200391_b();
        if (!this.seenAdvancements.add(t.func_192067_g())) {
            throw new IllegalStateException("Duplicate advancement " + t.func_192067_g());
        }
        Path path1 = RegistrateAdvancementProvider.getPath(path, t);
        try {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)t.func_192075_a().func_200273_b(), (Path)path1);
        }
        catch (IOException ioexception) {
            log.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
        }
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Advancements";
    }
}

