/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.recipe;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.recipe.FluxStorageRecipe;

public class FluxStorageRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FluxStorageRecipe> {
    public static final FluxStorageRecipeSerializer INSTANCE = new FluxStorageRecipeSerializer();

    @Nonnull
    public FluxStorageRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        return new FluxStorageRecipe((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json));
    }

    public FluxStorageRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            return new FluxStorageRecipe(Objects.requireNonNull((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer)));
        }
        catch (Exception e) {
            FluxNetworks.LOGGER.error("Error reading Flux Storage Recipe from Packet", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull FluxStorageRecipe recipe) {
        try {
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
        }
        catch (Exception e) {
            FluxNetworks.LOGGER.error("Error writing Flux Storage Recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

