/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.text.FluxTranslate;

public enum WirelessType {
    ENABLE_WIRELESS(FluxTranslate.ENABLE_WIRELESS),
    MAIN_HAND(FluxTranslate.MAIN_HAND),
    OFF_HAND(FluxTranslate.OFF_HAND),
    HOT_BAR(FluxTranslate.HOT_BAR),
    ARMOR(FluxTranslate.ARMOR),
    CURIOS(FluxTranslate.CURIOS),
    INVENTORY(FluxTranslate.INVENTORY);

    private final FluxTranslate typeName;

    private WirelessType(FluxTranslate typeName) {
        this.typeName = typeName;
    }

    public boolean isActivated(int setting) {
        if (this == INVENTORY) {
            return false;
        }
        return (setting >> this.ordinal() & 1) == 1;
    }

    public boolean isActivated(@Nonnull IFluxNetwork network) {
        return this.isActivated(network.getWirelessMode());
    }

    @Nonnull
    public String getTranslatedName() {
        return this.typeName.t();
    }
}

