/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.objects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.common.CuriosHelper;

public class SetCurioAttributes
extends LootFunction {
    public static LootFunctionType TYPE = null;
    final List<Modifier> modifiers;

    SetCurioAttributes(ILootCondition[] conditions, List<Modifier> modifiers) {
        super(conditions);
        this.modifiers = ImmutableList.copyOf(modifiers);
    }

    public static void register() {
        TYPE = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation("curios", "set_curio_attributes"), (Object)new LootFunctionType((ILootSerializer)new Serializer()));
    }

    @Nonnull
    public LootFunctionType func_230425_b_() {
        return TYPE;
    }

    @Nonnull
    public ItemStack func_215859_a(@Nonnull ItemStack stack, LootContext context) {
        Random random = context.func_216032_b();
        for (Modifier modifier : this.modifiers) {
            UUID uuid = modifier.id;
            String slot = (String)Util.func_240989_a_((Object[])modifier.slots, (Random)random);
            if (modifier.attribute instanceof CuriosHelper.SlotAttributeWrapper) {
                CuriosHelper.SlotAttributeWrapper wrapper = (CuriosHelper.SlotAttributeWrapper)modifier.attribute;
                CuriosApi.getCuriosHelper().addSlotModifier(stack, wrapper.identifier, modifier.name, uuid, modifier.amount.func_186507_b(random), modifier.operation, slot);
                continue;
            }
            CuriosApi.getCuriosHelper().addModifier(stack, modifier.attribute, modifier.name, uuid, modifier.amount.func_186507_b(random), modifier.operation, slot);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetCurioAttributes> {
        public void serialize(@Nonnull JsonObject object, @Nonnull SetCurioAttributes function, @Nonnull JsonSerializationContext context) {
            super.func_230424_a_(object, (LootFunction)function, context);
            JsonArray jsonarray = new JsonArray();
            for (Modifier modifier : function.modifiers) {
                jsonarray.add((JsonElement)modifier.serialize(context));
            }
            object.add("modifiers", (JsonElement)jsonarray);
        }

        @Nonnull
        public SetCurioAttributes deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext context, @Nonnull ILootCondition[] conditions) {
            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)object, (String)"modifiers");
            ArrayList list = Lists.newArrayListWithExpectedSize((int)jsonarray.size());
            for (JsonElement jsonelement : jsonarray) {
                list.add(Modifier.deserialize(JSONUtils.func_151210_l((JsonElement)jsonelement, (String)"modifier"), context));
            }
            if (list.isEmpty()) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new SetCurioAttributes(conditions, list);
        }
    }

    static class Modifier {
        final String name;
        final Attribute attribute;
        final AttributeModifier.Operation operation;
        final RandomValueRange amount;
        @Nullable
        final UUID id;
        final String[] slots;

        Modifier(String name, Attribute attribute, AttributeModifier.Operation operation, RandomValueRange amount, String[] slots, @Nullable UUID uuid) {
            this.name = name;
            this.attribute = attribute;
            this.operation = operation;
            this.amount = amount;
            this.id = uuid;
            this.slots = slots;
        }

        public JsonObject serialize(JsonSerializationContext context) {
            ResourceLocation rl;
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("name", this.name);
            if (this.attribute instanceof CuriosHelper.SlotAttributeWrapper) {
                CuriosHelper.SlotAttributeWrapper wrapper = (CuriosHelper.SlotAttributeWrapper)this.attribute;
                rl = new ResourceLocation("curios", wrapper.identifier);
            } else {
                rl = ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)this.attribute);
            }
            if (rl != null) {
                jsonobject.addProperty("attribute", rl.toString());
            }
            jsonobject.addProperty("operation", Modifier.operationToString(this.operation));
            jsonobject.add("amount", context.serialize((Object)this.amount));
            if (this.id != null) {
                jsonobject.addProperty("id", this.id.toString());
            }
            if (this.slots.length == 1) {
                jsonobject.addProperty("slot", this.slots[0]);
            } else {
                JsonArray jsonarray = new JsonArray();
                for (String slot : this.slots) {
                    jsonarray.add((JsonElement)new JsonPrimitive(slot));
                }
                jsonobject.add("slot", (JsonElement)jsonarray);
            }
            return jsonobject;
        }

        public static Modifier deserialize(JsonObject object, JsonDeserializationContext context) {
            String[] slots;
            Attribute attribute;
            String s = JSONUtils.func_151200_h((JsonObject)object, (String)"name");
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"attribute"));
            if (resourcelocation.func_110624_b().equals("curios")) {
                String identifier = resourcelocation.func_110623_a();
                if (!CuriosApi.getSlotHelper().getSlotType(identifier).isPresent()) {
                    throw new JsonSyntaxException("Unknown curios slot type: " + identifier);
                }
                attribute = CuriosHelper.getOrCreateSlotAttribute(identifier);
            } else {
                attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(resourcelocation);
            }
            if (attribute == null) {
                throw new JsonSyntaxException("Unknown attribute: " + resourcelocation);
            }
            AttributeModifier.Operation operation = Modifier.operationFromString(JSONUtils.func_151200_h((JsonObject)object, (String)"operation"));
            RandomValueRange numberprovider = (RandomValueRange)JSONUtils.func_188174_a((JsonObject)object, (String)"amount", (JsonDeserializationContext)context, RandomValueRange.class);
            UUID uuid = null;
            if (JSONUtils.func_151205_a((JsonObject)object, (String)"slot")) {
                slots = new String[]{JSONUtils.func_151200_h((JsonObject)object, (String)"slot")};
            } else {
                if (!JSONUtils.func_151202_d((JsonObject)object, (String)"slot")) {
                    throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
                }
                JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)object, (String)"slot");
                slots = new String[jsonarray.size()];
                int i = 0;
                for (JsonElement jsonelement : jsonarray) {
                    slots[i++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)"slot");
                }
                if (slots.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            }
            if (object.has("id")) {
                String s1 = JSONUtils.func_151200_h((JsonObject)object, (String)"id");
                try {
                    uuid = UUID.fromString(s1);
                }
                catch (IllegalArgumentException illegalargumentexception) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + s1 + "' (must be UUID format, with dashes)");
                }
            }
            return new Modifier(s, attribute, operation, numberprovider, slots, uuid);
        }

        private static String operationToString(AttributeModifier.Operation operation) {
            switch (operation) {
                case ADDITION: {
                    return "addition";
                }
                case MULTIPLY_BASE: {
                    return "multiply_base";
                }
                case MULTIPLY_TOTAL: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException();
        }

        private static AttributeModifier.Operation operationFromString(String operation) {
            switch (operation) {
                case "addition": {
                    return AttributeModifier.Operation.ADDITION;
                }
                case "multiply_base": {
                    return AttributeModifier.Operation.MULTIPLY_BASE;
                }
                case "multiply_total": {
                    return AttributeModifier.Operation.MULTIPLY_TOTAL;
                }
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + operation);
        }
    }
}

