/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;

public class CPacketDestroy {
    public static void encode(CPacketDestroy msg, PacketBuffer buf) {
    }

    public static CPacketDestroy decode(PacketBuffer buf) {
        return new CPacketDestroy();
    }

    public static void handle(CPacketDestroy msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)sender).ifPresent(handler -> handler.getCurios().values().forEach(stacksHandler -> {
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
                    String id = stacksHandler.getIdentifier();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        UUID uuid = UUID.nameUUIDFromBytes((id + i).getBytes());
                        SlotContext slotContext = new SlotContext(id, (LivingEntity)sender, i);
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        Multimap<Attribute, AttributeModifier> map = CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack);
                        HashMultimap slots = HashMultimap.create();
                        HashSet<CuriosHelper.SlotAttributeWrapper> toRemove = new HashSet<CuriosHelper.SlotAttributeWrapper>();
                        for (Attribute attribute : map.keySet()) {
                            if (!(attribute instanceof CuriosHelper.SlotAttributeWrapper)) continue;
                            CuriosHelper.SlotAttributeWrapper wrapper = (CuriosHelper.SlotAttributeWrapper)attribute;
                            slots.putAll((Object)wrapper.identifier, (Iterable)map.get((Object)attribute));
                            toRemove.add(wrapper);
                        }
                        for (Attribute attribute : toRemove) {
                            map.removeAll((Object)attribute);
                        }
                        sender.func_233645_dx_().func_233785_a_(map);
                        handler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
                        CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, stack));
                        stackHandler.setStackInSlot(i, ItemStack.field_190927_a);
                        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SPacketSyncStack(sender.func_145782_y(), id, i, ItemStack.field_190927_a, SPacketSyncStack.HandlerType.EQUIPMENT, new CompoundNBT()));
                        cosmeticStackHandler.setStackInSlot(i, ItemStack.field_190927_a);
                        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SPacketSyncStack(sender.func_145782_y(), id, i, ItemStack.field_190927_a, SPacketSyncStack.HandlerType.COSMETIC, new CompoundNBT()));
                    }
                }));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

