/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.Chisel;
import team.chisel.api.chunkdata.ChunkData;
import team.chisel.api.chunkdata.IChunkData;
import team.chisel.api.chunkdata.IChunkDataRegistry;
import team.chisel.client.ClientProxy;
import team.chisel.common.util.NBTSaveable;

public enum PerChunkData implements IChunkDataRegistry
{
    INSTANCE;

    private Map<String, IChunkData<?>> data = Maps.newHashMap();

    private PerChunkData() {
        ChunkData.setOffsetRegistry(this);
    }

    @Override
    public void registerChunkData(String key, IChunkData<?> cd) {
        this.data.put(key, cd);
    }

    @Override
    public <T extends IChunkData<?>> T getData(String key) {
        return (T)this.data.get(key);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            e.getValue().writeToNBT(event.getChunk(), tag);
            event.getData().func_218657_a("chisel:" + e.getKey(), (INBT)tag);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            CompoundNBT tag = event.getData().func_74775_l("chisel:" + e.getKey());
            IChunk chunk = event.getChunk();
            e.getValue().readFromNBT(chunk, tag);
            if (!(chunk instanceof Chunk)) continue;
            this.updateClient((Chunk)chunk, e.getKey(), e.getValue());
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            if (!e.getValue().requiresClientSync()) continue;
            Chisel.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageChunkData(e.getKey(), e.getValue()));
        }
    }

    public void chunkModified(Chunk chunk, String key) {
        IChunkData<?> cd = this.data.get(key);
        chunk.func_177427_f(true);
        this.updateClient(chunk, key, cd);
    }

    private void updateClient(@Nonnull Chunk chunk, String key, IChunkData<?> cd) {
        if (cd.requiresClientSync()) {
            CompoundNBT tag = new CompoundNBT();
            cd.writeToNBT((IChunk)chunk, tag);
            Chisel.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new MessageChunkData(chunk, key, tag));
        }
    }

    public static class ChunkDataBase<T extends NBTSaveable>
    implements IChunkData<T> {
        protected final Map<Pair<RegistryKey<World>, ChunkPos>, T> data = new HashMap<Pair<RegistryKey<World>, ChunkPos>, T>();
        protected final Class<? extends T> clazz;
        private final boolean needsClientSync;

        public ChunkDataBase(Class<? extends T> clazz, boolean needsClientSync) {
            this.clazz = clazz;
            this.needsClientSync = needsClientSync;
        }

        @Override
        public ListNBT writeToNBT() {
            ListNBT tags = new ListNBT();
            for (Map.Entry<Pair<RegistryKey<World>, ChunkPos>, T> e : this.data.entrySet()) {
                CompoundNBT entry = new CompoundNBT();
                entry.func_74778_a("d", ((RegistryKey)e.getKey().getLeft()).func_240901_a_().toString());
                entry.func_74772_a("p", (long)(((ChunkPos)e.getKey().getRight()).field_77276_a << 32 | ((ChunkPos)e.getKey().getRight()).field_77275_b));
                CompoundNBT data = new CompoundNBT();
                ((NBTSaveable)e.getValue()).write(data);
                entry.func_218657_a("v", (INBT)data);
                tags.add((Object)entry);
            }
            return tags;
        }

        @Override
        public void writeToNBT(@Nonnull IChunk chunk, @Nonnull CompoundNBT tag) {
            NBTSaveable t = (NBTSaveable)this.data.get(Pair.of((Object)((World)chunk.getWorldForge()).func_234923_W_(), (Object)chunk.func_76632_l()));
            if (t != null) {
                t.write(tag);
            }
        }

        @Override
        public Iterable<ChunkPos> readFromNBT(@Nonnull ListNBT tags) {
            ArrayList<ChunkPos> changed = new ArrayList<ChunkPos>();
            for (int i = 0; i < tags.size(); ++i) {
                long coordsRaw;
                ChunkPos coords;
                CompoundNBT entry = tags.func_150305_b(i);
                RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(entry.func_74779_i("d")));
                if (!this.readFromNBT((RegistryKey<World>)dim, coords = new ChunkPos((int)((coordsRaw = entry.func_74763_f("p")) >>> 32 & 0xFFFFFFFFFFFFFFFFL), (int)(coordsRaw & 0xFFFFFFFFFFFFFFFFL)), entry.func_74775_l("v"))) continue;
                changed.add(coords);
            }
            return changed;
        }

        @Override
        public void readFromNBT(@Nonnull IChunk chunk, @Nonnull CompoundNBT tag) {
            RegistryKey type = ((World)chunk.getWorldForge()).func_234923_W_();
            ChunkPos coords = chunk.func_76632_l();
            this.readFromNBT((RegistryKey<World>)type, coords, tag);
        }

        private boolean readFromNBT(RegistryKey<World> dim, ChunkPos coords, CompoundNBT tag) {
            if (tag.isEmpty()) {
                this.data.remove(dim, coords);
                return false;
            }
            T t = this.getOrCreateNew(dim, coords);
            t.read(tag);
            return true;
        }

        protected T getOrCreateNew(RegistryKey<World> dim, @Nonnull ChunkPos coords) {
            Pair pair = Pair.of(dim, (Object)coords);
            NBTSaveable t = (NBTSaveable)this.data.get(pair);
            if (t == null) {
                try {
                    t = (NBTSaveable)this.clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate NBTSaveable " + this.clazz.getName() + "!", e);
                }
            }
            this.data.put((Pair<RegistryKey<World>, ChunkPos>)pair, t);
            return (T)t;
        }

        @Override
        public boolean requiresClientSync() {
            return this.needsClientSync && !this.data.isEmpty();
        }

        @Override
        public T getDataForChunk(RegistryKey<World> dim, @Nonnull ChunkPos coords) {
            return this.getOrCreateNew(dim, coords);
        }
    }

    public static class MessageChunkData {
        private final ChunkPos chunk;
        private final String key;
        @Nonnull
        private final CompoundNBT tag;

        public MessageChunkData(Chunk chunk, String key, @Nonnull CompoundNBT tag) {
            this(chunk.func_76632_l(), key, tag);
        }

        public MessageChunkData(String key, IChunkData<?> iChunkData) {
            this((ChunkPos)null, key, new CompoundNBT());
            this.tag.func_218657_a("l", (INBT)iChunkData.writeToNBT());
        }

        public void encode(PacketBuffer buf) {
            if (this.chunk == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(this.chunk.field_77276_a);
                buf.writeInt(this.chunk.field_77275_b);
            }
            buf.func_211400_a(this.key, 64);
            buf.func_150786_a(this.tag);
        }

        public static MessageChunkData decode(PacketBuffer buf) {
            ChunkPos chunk = null;
            if (buf.readBoolean()) {
                chunk = new ChunkPos(buf.readInt(), buf.readInt());
            }
            return new MessageChunkData(chunk, buf.func_150789_c(64), buf.func_150793_b());
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Chunk chunk = null;
                if (this.chunk != null) {
                    chunk = ClientProxy.getClientWorld().func_212866_a_(this.chunk.field_77276_a, this.chunk.field_77275_b);
                }
                IChunkData data = (IChunkData)INSTANCE.data.get(this.key);
                if (chunk != null) {
                    data.readFromNBT((IChunk)chunk, this.tag);
                    int x = chunk.func_76632_l().field_77276_a << 4;
                    int z = chunk.func_76632_l().field_77275_b << 4;
                    ClientProxy.getWorldRenderer().func_147585_a(x, 0, z, x, 255, z);
                } else {
                    for (ChunkPos pos : data.readFromNBT(this.tag.func_150295_c("l", 10))) {
                        ClientProxy.getWorldRenderer().func_147585_a(pos.field_77276_a, 0, pos.field_77275_b, pos.field_77276_a, 255, pos.field_77275_b);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public MessageChunkData(ChunkPos chunk, String key, @Nonnull CompoundNBT tag) {
            if (tag == null) {
                throw new NullPointerException("tag is marked non-null but is null");
            }
            this.chunk = chunk;
            this.key = key;
            this.tag = tag;
        }
    }
}

