/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import team.chisel.api.IChiselItem;
import team.chisel.common.inventory.ChiselContainer;
import team.chisel.common.item.ItemChisel;

@ParametersAreNonnullByDefault
public class InventoryChiselSelection
implements IInventory {
    ItemStack chisel = ItemStack.field_190927_a;
    public final int size;
    public int activeVariations = 0;
    @Nullable
    ChiselContainer container;
    NonNullList<ItemStack> inventory;

    public InventoryChiselSelection(ItemStack c, int size) {
        this.size = size;
        this.inventory = NonNullList.func_191197_a((int)(size + 1), (Object)ItemStack.field_190927_a);
        this.chisel = c;
    }

    public void onInventoryUpdate(int slot) {
    }

    public int func_70302_i_() {
        return this.size + 1;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.inventory.get(var1);
    }

    public void updateInventoryState(int slot) {
        this.onInventoryUpdate(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.updateInventoryState(slot);
                return stack;
            }
            ItemStack split = stack.func_77979_a(amount);
            if (stack.func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
            this.updateInventoryState(slot);
            return split;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        this.func_70299_a(slot, ItemStack.field_190927_a);
        this.inventory.set(slot, (Object)ItemStack.field_190927_a);
        this.updateInventoryState(slot);
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity player) {
        ItemStack held = player.field_71071_by.func_70301_a(this.container.getChiselSlot());
        return !held.func_190926_b() && held.func_77973_b() instanceof IChiselItem && ((IChiselItem)held.func_77973_b()).canOpenGui(player.field_70170_p, player, this.container.hand);
    }

    public void clearItems() {
        this.activeVariations = 0;
        for (int i = 0; i < this.size; ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public ItemStack getStackInSpecialSlot() {
        return (ItemStack)this.inventory.get(this.size);
    }

    public void setStackInSpecialSlot(ItemStack stack) {
        this.func_70299_a(this.size, stack);
    }

    public void updateItems() {
        ItemStack chiseledItem = this.getStackInSpecialSlot();
        this.clearItems();
        if (chiseledItem.func_190926_b()) {
            return;
        }
        Item item = chiseledItem.func_77973_b();
        List<ItemStack> list = this.container.getCarving().getItemsForChiseling(chiseledItem);
        this.activeVariations = 0;
        while (this.activeVariations < this.size && this.activeVariations < list.size()) {
            this.func_70299_a(this.activeVariations, list.get(this.activeVariations));
            ++this.activeVariations;
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.updateInventoryState(slot);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemChisel)) && i == this.size;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_174889_b(PlayerEntity var1) {
    }

    public void func_174886_c(PlayerEntity var1) {
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }
}

