/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.data;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import team.chisel.api.block.ModelTemplate;
import team.chisel.api.block.RecipeTemplate;
import team.chisel.api.block.VariantTemplate;
import team.chisel.client.data.ModelTemplates;
import team.chisel.common.block.BlockCarvable;
import team.chisel.repack.registrate.providers.RegistrateRecipeProvider;
import team.chisel.repack.registrate.util.nullness.FieldsAreNonnullByDefault;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class VariantTemplates {
    public static final VariantTemplate RAW = VariantTemplates.simple("raw", new String[0]);
    public static final ImmutableList<VariantTemplate> COLORS = ImmutableList.copyOf((Collection)Arrays.stream(DyeColor.values()).map(color -> VariantTemplates.simple(color.func_176610_l(), new String[0])).collect(Collectors.toList()));
    public static final ImmutableList<VariantTemplate> METAL = VariantTemplates.ofClass(Metal.class);
    public static final ImmutableList<VariantTemplate> STONE = VariantTemplates.ofClass(Stone.class);
    public static final ImmutableList<VariantTemplate> ROCK = VariantTemplates.ofClass(Rock.class);
    public static final ImmutableList<VariantTemplate> COBBLESTONE = ImmutableList.builder().addAll(ROCK).add((Object)VariantTemplates.withName("extra/emboss", "Embossed", new String[0])).add((Object)VariantTemplates.withName("extra/indent", "Indent", new String[0])).add((Object)VariantTemplates.withName("extra/marker", "Marker", new String[0])).build();
    public static final ImmutableList<VariantTemplate> COBBLESTONE_MOSSY = ImmutableList.copyOf((Collection)COBBLESTONE.stream().map(v -> SimpleTemplate.builderFrom(v).modelTemplate(VariantTemplates.mossyModel("cobblestone", v)).build()).collect(Collectors.toList()));
    public static final ImmutableList<VariantTemplate> PLANKS = VariantTemplates.ofClass(Planks.class);

    public static VariantTemplate empty(String name, String ... tooltip) {
        return VariantTemplates.simple(name, null, tooltip);
    }

    public static VariantTemplate simple(String name, String ... tooltip) {
        return VariantTemplates.simple(name, ModelTemplates.simpleBlock(), tooltip);
    }

    public static VariantTemplate simple(String name, @Nullable ModelTemplate template, String ... tooltip) {
        return SimpleTemplate.builder().name(name).modelTemplate(template).tooltip(tooltip).build();
    }

    public static VariantTemplate withName(String name, String localizedName, String ... tooltip) {
        return VariantTemplates.withName(name, localizedName, ModelTemplates.simpleBlock(), tooltip);
    }

    public static VariantTemplate withName(String name, String localizedName, @Nullable ModelTemplate template, String ... tooltip) {
        return SimpleTemplate.builder().name(name).localizedName(localizedName).modelTemplate(template).tooltip(tooltip).build();
    }

    private static ImmutableList<VariantTemplate> ofClass(Class<?> cls) {
        return ImmutableList.copyOf((Collection)Arrays.stream(cls.getDeclaredFields()).map(f -> {
            try {
                return (VariantTemplate)f.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()));
    }

    public static final ImmutableList<VariantTemplate> colors(ModelTemplate template) {
        return VariantTemplates.colors(template, null);
    }

    public static ImmutableList<VariantTemplate> colors(ModelTemplate model, RecipeTemplate whiteRecipe) {
        return ImmutableList.copyOf((Collection)COLORS.stream().map(SimpleTemplate::builderFrom).map(b -> b.modelTemplate(model)).map(b -> b.recipeTemplate(((SimpleTemplate.SimpleTemplateBuilder)b).name.equals(DyeColor.WHITE.func_176610_l()) ? whiteRecipe : null)).map(SimpleTemplate.SimpleTemplateBuilder::build).collect(Collectors.toList()));
    }

    private static ModelTemplate mossyModel(String base, VariantTemplate template) {
        if (template.getName().equals("circularct")) {
            return ModelTemplates.mossyCtm(base, "circular");
        }
        if (template.getName().equals("pillar") || template.getName().equals("twisted")) {
            return ModelTemplates.mossyColumn(base);
        }
        return ModelTemplates.mossy(base);
    }

    public static final SimpleTemplate withRecipe(VariantTemplate template, RecipeTemplate recipe) {
        return SimpleTemplate.builderFrom(template).recipeTemplate(recipe).build();
    }

    public static final ImmutableList<VariantTemplate> withUncraft(Collection<VariantTemplate> templates, Item item) {
        return ImmutableList.copyOf((Collection)templates.stream().map(SimpleTemplate::builderFrom).map(b -> b.recipeTemplate((prov, block) -> new ShapelessRecipeBuilder((IItemProvider)item, 9).func_200491_b((IItemProvider)block, 9).func_200483_a("has_" + item.getRegistryName().func_110623_a(), (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)item)).func_200484_a((Consumer)prov, "chisel:" + item.getRegistryName().func_110623_a() + "_from_" + ((BlockCarvable)block).getVariation().getName()))).map(SimpleTemplate.SimpleTemplateBuilder::build).collect(Collectors.toList()));
    }

    public static class Planks {
        public static final VariantTemplate LARGE_PLANKS = VariantTemplates.simple("large_planks", new String[0]);
        public static final VariantTemplate CRUDE_HORIZONTAL_PLANKS = VariantTemplates.simple("crude_horizontal_planks", new String[0]);
        public static final VariantTemplate VERTICAL_PLANKS = VariantTemplates.simple("vertical_planks", new String[0]);
        public static final VariantTemplate CRUDE_VERTICAL_PLANKS = VariantTemplates.simple("crude_vertical_planks", new String[0]);
        public static final VariantTemplate ENCASED_PLANKS = VariantTemplates.simple("encased_planks", new String[0]);
        public static final VariantTemplate ENCASED_LARGE_PLANKS = VariantTemplates.simple("encased_large_planks", new String[0]);
        public static final VariantTemplate BRACED_PLANKS = VariantTemplates.simple("braced_planks", ModelTemplates.cubeColumn(name -> ModelTemplates.replaceVariant(name, "log_bordered")), new String[0]);
        public static final VariantTemplate CRATE = VariantTemplates.simple("shipping_crate", new String[0]);
        public static final VariantTemplate PANELING = VariantTemplates.simple("paneling", new String[0]);
        public static final VariantTemplate CRUDE_PANELING = VariantTemplates.simple("crude_paneling", new String[0]);
        public static final VariantTemplate STACKED = VariantTemplates.simple("stacked", new String[0]);
        public static final VariantTemplate SMOOTH = VariantTemplates.simple("smooth", new String[0]);
        public static final VariantTemplate ENCASED_SMOOTH = VariantTemplates.simple("encased_smooth", new String[0]);
        public static final VariantTemplate BRAID = VariantTemplates.simple("braid", new String[0]);
        public static final VariantTemplate LOG_CABIN = VariantTemplates.simple("log_cabin", (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("cube_axis"))).texture("x", name + "-ew")).texture("y", ModelTemplates.replaceVariant(name, "log_bordered"))).texture("z", name + "-ns"));
        }, new String[0]);
    }

    public static class Rock {
        public static final VariantTemplate CRACKED = VariantTemplates.simple("cracked", new String[0]);
        public static final VariantTemplate SOLID_BRICKS = VariantTemplates.withName("solid_bricks", "Bricks", new String[0]);
        public static final VariantTemplate SMALL_BRICKS = VariantTemplates.simple("small_bricks", new String[0]);
        public static final VariantTemplate SOFT_BRICKS = VariantTemplates.withName("soft_bricks", "Weathered Bricks", new String[0]);
        public static final VariantTemplate CRACKED_BRICKS = VariantTemplates.simple("cracked_bricks", new String[0]);
        public static final VariantTemplate TRIPLE_BRICKS = VariantTemplates.withName("triple_bricks", "Wide Bricks", new String[0]);
        public static final VariantTemplate ENCASED_BRICKS = VariantTemplates.simple("encased_bricks", new String[0]);
        public static final VariantTemplate CHAOTIC_BRICKS = VariantTemplates.withName("chaotic_bricks", "Trodden Bricks", new String[0]);
        public static final VariantTemplate ARRAY = VariantTemplates.withName("array", "Arrayed Bricks", new String[0]);
        public static final VariantTemplate TILES_MEDIUM = VariantTemplates.withName("tiles_medium", "Tiles", new String[0]);
        public static final VariantTemplate TILES_LARGE = VariantTemplates.withName("tiles_large", "Big Tile", new String[0]);
        public static final VariantTemplate TILES_SMALL = VariantTemplates.withName("tiles_small", "Small Tiles", new String[0]);
        public static final VariantTemplate CHAOTIC_MEDIUM = VariantTemplates.withName("chaotic_medium", "Disordered Tiles", new String[0]);
        public static final VariantTemplate CHAOTIC_SMALL = VariantTemplates.withName("chaotic_small", "Small Disordered Tiles", new String[0]);
        public static final VariantTemplate BRAID = VariantTemplates.simple("braid", new String[0]);
        public static final VariantTemplate DENT = VariantTemplates.simple("dent", new String[0]);
        public static final VariantTemplate FRENCH_1 = VariantTemplates.simple("french_1", new String[0]);
        public static final VariantTemplate FRENCH_2 = VariantTemplates.simple("french_2", new String[0]);
        public static final VariantTemplate JELLYBEAN = VariantTemplates.simple("jellybean", new String[0]);
        public static final VariantTemplate LAYERS = VariantTemplates.simple("layers", new String[0]);
        public static final VariantTemplate MOSAIC = VariantTemplates.simple("mosaic", new String[0]);
        public static final VariantTemplate ORNATE = VariantTemplates.simple("ornate", new String[0]);
        public static final VariantTemplate PANEL = VariantTemplates.simple("panel", new String[0]);
        public static final VariantTemplate ROAD = VariantTemplates.simple("road", new String[0]);
        public static final VariantTemplate SLANTED = VariantTemplates.simple("slanted", new String[0]);
        public static final VariantTemplate ZAG = VariantTemplates.simple("zag", new String[0]);
        public static final VariantTemplate CIRCULAR = VariantTemplates.simple("circular", new String[0]);
        public static final VariantTemplate CIRCULAR_CTM = VariantTemplates.withName("circularct", "Circular", ModelTemplates.ctm("circular"), "Has CTM");
        public static final VariantTemplate WEAVER = VariantTemplates.withName("weaver", "Celtic", new String[0]);
        public static final VariantTemplate PILLAR = VariantTemplates.simple("pillar", ModelTemplates.cubeColumn(), new String[0]);
        public static final VariantTemplate TWISTED = VariantTemplates.simple("twisted", ModelTemplates.cubeColumn(), new String[0]);
        public static final VariantTemplate PRISM = VariantTemplates.simple("prism", new String[0]);
        public static final VariantTemplate CUTS = VariantTemplates.simple("cuts", new String[0]);
    }

    public static class Stone {
        public static final VariantTemplate CRACKED = VariantTemplates.simple("cracked", new String[0]);
        public static final VariantTemplate SOLID_BRICKS = VariantTemplates.withName("solid_bricks", "Bricks", new String[0]);
        public static final VariantTemplate SMALL_BRICKS = VariantTemplates.simple("small_bricks", new String[0]);
        public static final VariantTemplate SOFT_BRICKS = VariantTemplates.withName("soft_bricks", "Weathered Bricks", new String[0]);
        public static final VariantTemplate CRACKED_BRICKS = VariantTemplates.simple("cracked_bricks", new String[0]);
        public static final VariantTemplate TRIPLE_BRICKS = VariantTemplates.withName("triple_bricks", "Wide Bricks", new String[0]);
        public static final VariantTemplate ENCASED_BRICKS = VariantTemplates.simple("encased_bricks", new String[0]);
        public static final VariantTemplate ARRAY = VariantTemplates.withName("array", "Arrayed Bricks", new String[0]);
        public static final VariantTemplate TILES_MEDIUM = VariantTemplates.withName("tiles_medium", "Tiles", new String[0]);
        public static final VariantTemplate TILES_LARGE = VariantTemplates.withName("tiles_large", "Big Tile", new String[0]);
        public static final VariantTemplate TILES_SMALL = VariantTemplates.withName("tiles_small", "Small Tiles", new String[0]);
        public static final VariantTemplate CHAOTIC_MEDIUM = VariantTemplates.withName("chaotic_medium", "Disordered Tiles", new String[0]);
        public static final VariantTemplate CHAOTIC_SMALL = VariantTemplates.withName("chaotic_small", "Small Disordered Tiles", new String[0]);
        public static final VariantTemplate BRAID = VariantTemplates.simple("braid", new String[0]);
        public static final VariantTemplate DENT = VariantTemplates.simple("dent", new String[0]);
        public static final VariantTemplate FRENCH_1 = VariantTemplates.simple("french_1", new String[0]);
        public static final VariantTemplate FRENCH_2 = VariantTemplates.simple("french_2", new String[0]);
        public static final VariantTemplate JELLYBEAN = VariantTemplates.simple("jellybean", new String[0]);
        public static final VariantTemplate LAYERS = VariantTemplates.simple("layers", new String[0]);
        public static final VariantTemplate MOSAIC = VariantTemplates.simple("mosaic", new String[0]);
        public static final VariantTemplate ORNATE = VariantTemplates.simple("ornate", new String[0]);
        public static final VariantTemplate PANEL = VariantTemplates.simple("panel", new String[0]);
        public static final VariantTemplate ROAD = VariantTemplates.simple("road", new String[0]);
        public static final VariantTemplate SLANTED = VariantTemplates.simple("slanted", new String[0]);
        public static final VariantTemplate CIRCULAR = VariantTemplates.simple("circular", new String[0]);
        public static final VariantTemplate PILLAR = VariantTemplates.simple("pillar", ModelTemplates.cubeColumn(), new String[0]);
        public static final VariantTemplate TWISTED = VariantTemplates.simple("twisted", ModelTemplates.cubeColumn(), new String[0]);
        public static final VariantTemplate PRISM = VariantTemplates.simple("prism", new String[0]);
    }

    @FieldsAreNonnullByDefault
    public static class Metal {
        public static final VariantTemplate CAUTION = VariantTemplates.simple("caution", new String[0]);
        public static final VariantTemplate CRATE = VariantTemplates.withName("crate", "Shipping Crate", new String[0]);
        public static final VariantTemplate THERMAL = VariantTemplates.simple("thermal", ModelTemplates.cubeBottomTop(), new String[0]);
        public static final VariantTemplate MACHINE = VariantTemplates.simple("machine", "An Old Relic From The", "Land Of OneTeuFyv");
        public static final VariantTemplate BADGREGGY = VariantTemplates.withName("badgreggy", "Egregious", new String[0]);
        public static final VariantTemplate BOLTED = VariantTemplates.simple("bolted", new String[0]);
        public static final VariantTemplate SCAFFOLD = VariantTemplates.simple("scaffold", new String[0]);
    }

    @MethodsReturnNonnullByDefault
    public static class SimpleTemplate
    implements VariantTemplate {
        private final String name;
        private final String localizedName;
        private final ModelTemplate modelTemplate;
        private final RecipeTemplate recipeTemplate;
        private final String[] tooltip;

        @Override
        public String getLocalizedName() {
            return this.localizedName == null ? VariantTemplate.super.getLocalizedName() : this.localizedName;
        }

        @Override
        public Optional<ModelTemplate> getModelTemplate() {
            return Optional.ofNullable(this.modelTemplate);
        }

        @Override
        public Optional<RecipeTemplate> getRecipeTemplate() {
            return Optional.ofNullable(this.recipeTemplate);
        }

        public static SimpleTemplateBuilder builderFrom(VariantTemplate from) {
            return SimpleTemplate.builder().name(from.getName()).localizedName(from instanceof SimpleTemplate ? ((SimpleTemplate)from).localizedName : from.getLocalizedName()).modelTemplate(from.getModelTemplate().orElse(null)).recipeTemplate(from.getRecipeTemplate().orElse(null)).tooltip(from.getTooltip());
        }

        public static SimpleTemplateBuilder builder() {
            return new SimpleTemplateBuilder();
        }

        public SimpleTemplate(String name, String localizedName, ModelTemplate modelTemplate, RecipeTemplate recipeTemplate, String[] tooltip) {
            this.name = name;
            this.localizedName = localizedName;
            this.modelTemplate = modelTemplate;
            this.recipeTemplate = recipeTemplate;
            this.tooltip = tooltip;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getTooltip() {
            return this.tooltip;
        }

        public static class SimpleTemplateBuilder {
            private String name;
            private String localizedName;
            private ModelTemplate modelTemplate;
            private RecipeTemplate recipeTemplate;
            private String[] tooltip;

            SimpleTemplateBuilder() {
            }

            public SimpleTemplateBuilder name(String name) {
                this.name = name;
                return this;
            }

            public SimpleTemplateBuilder localizedName(String localizedName) {
                this.localizedName = localizedName;
                return this;
            }

            public SimpleTemplateBuilder modelTemplate(ModelTemplate modelTemplate) {
                this.modelTemplate = modelTemplate;
                return this;
            }

            public SimpleTemplateBuilder recipeTemplate(RecipeTemplate recipeTemplate) {
                this.recipeTemplate = recipeTemplate;
                return this;
            }

            public SimpleTemplateBuilder tooltip(String[] tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public SimpleTemplate build() {
                return new SimpleTemplate(this.name, this.localizedName, this.modelTemplate, this.recipeTemplate, this.tooltip);
            }

            public String toString() {
                return "VariantTemplates.SimpleTemplate.SimpleTemplateBuilder(name=" + this.name + ", localizedName=" + this.localizedName + ", modelTemplate=" + this.modelTemplate + ", recipeTemplate=" + this.recipeTemplate + ", tooltip=" + Arrays.deepToString(this.tooltip) + ")";
            }
        }
    }
}

