/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.carving;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;
import team.chisel.Chisel;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.IModeRegistry;
import team.chisel.api.carving.IVariationRegistry;
import team.chisel.common.init.ChiselSounds;

@ParametersAreNonnullByDefault
public class CarvingUtils {
    @Nullable
    public static IVariationRegistry chisel;
    @Nullable
    public static IModeRegistry modes;

    @Nullable
    public static IVariationRegistry getChiselRegistry() {
        return chisel;
    }

    @Nullable
    public static IModeRegistry getModeRegistry() {
        return modes;
    }

    public static boolean stacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static int hashStack(ItemStack stack) {
        return Objects.hashCode((Object[])new Object[]{stack.func_77973_b(), stack.func_77978_p()});
    }

    private static TranslationTextComponent getDisplayName(ITag.INamedTag<?> tag, String name) {
        return Chisel.registrate().addLang("group", tag.func_230234_a_(), name);
    }

    public static ICarvingGroup itemGroup(ITag.INamedTag<Block> blocks, String name) {
        return new BlockTagGroup(blocks, CarvingUtils.getDisplayName(blocks, name));
    }

    public static ICarvingGroup blockGroup(ITag.INamedTag<Item> items, String name) {
        return new ItemTagGroup(items, CarvingUtils.getDisplayName(items, name));
    }

    private static class ItemTagGroup
    extends AbstractGroup {
        public ItemTagGroup(ITag.INamedTag<Item> tag, TranslationTextComponent displayName) {
            super(tag.func_230234_a_(), displayName);
        }
    }

    private static class BlockTagGroup
    extends AbstractGroup {
        public BlockTagGroup(ITag.INamedTag<Block> tag, TranslationTextComponent displayName) {
            super(tag.func_230234_a_(), displayName);
        }
    }

    private static abstract class AbstractGroup
    implements ICarvingGroup {
        private final ResourceLocation id;
        private final SoundEvent sound = ChiselSounds.fallback;
        private final TranslationTextComponent displayName;

        @Override
        public String getTranslationKey() {
            return this.displayName.func_150268_i();
        }

        protected AbstractGroup(ResourceLocation id, TranslationTextComponent displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public SoundEvent getSound() {
            return this.sound;
        }

        @Override
        public TranslationTextComponent getDisplayName() {
            return this.displayName;
        }
    }
}

