/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.network;

import com.dannyandson.rangedwirelessredstone.blocks.AbstractWirelessEntity;
import com.dannyandson.rangedwirelessredstone.blocks.tinyredstonecells.AbstractWirelessCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetChannel {
    private final BlockPos pos;
    private final Integer channel;
    private Integer cellIndex;

    public SetChannel(BlockPos pos, @Nullable Integer cellIndex, int channel) {
        this.pos = pos;
        this.channel = channel;
        this.cellIndex = cellIndex;
    }

    public SetChannel(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.channel = buffer.readInt();
        try {
            this.cellIndex = buffer.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            this.cellIndex = null;
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.channel.intValue());
        if (this.cellIndex != null) {
            buf.writeInt(this.cellIndex.intValue());
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PanelCellPos panelCellPos;
            TileEntity blockEntity = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_175625_s(this.pos);
            if (blockEntity instanceof AbstractWirelessEntity) {
                ((AbstractWirelessEntity)blockEntity).setChannel(this.channel);
            } else if (this.cellIndex != null && ModList.get().isLoaded("tinyredstone") && blockEntity instanceof PanelTile && (panelCellPos = PanelCellPos.fromIndex((PanelTile)((PanelTile)blockEntity), (Integer)this.cellIndex)).getIPanelCell() instanceof AbstractWirelessCell) {
                ((AbstractWirelessCell)panelCellPos.getIPanelCell()).setChannel(this.channel);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

