/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.logic;

import com.dannyandson.rangedwirelessredstone.Config;
import com.dannyandson.rangedwirelessredstone.blocks.TransmitterBlockEntity;
import com.dannyandson.rangedwirelessredstone.blocks.tinyredstonecells.TransmitterCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.ModList;

public class ChannelData {
    public static Map<Integer, ChannelData> levelChannelDataMap = new HashMap<Integer, ChannelData>();
    private final ChannelSaveData saveData;

    public static ChannelData getChannelData(ServerWorld level) {
        int dim = level.func_234923_W_().hashCode();
        if (!levelChannelDataMap.containsKey(dim)) {
            levelChannelDataMap.put(dim, new ChannelData(level));
        }
        return levelChannelDataMap.get(dim);
    }

    private ChannelData(ServerWorld level) {
        this.saveData = (ChannelSaveData)level.func_217481_x().func_215752_a(ChannelSaveData::new, "rangedwirelessredstone");
    }

    public void setTransmitterChannel(BlockPos pos, int channel) {
        this.setTransmitterChannel(ChannelData.getStringFromPos(pos), channel);
    }

    public void setTransmitterChannel(BlockPos pos, int cellIndex, int channel) {
        this.setTransmitterChannel(ChannelData.getStringFromPos(pos) + ", " + cellIndex, channel);
    }

    private void setTransmitterChannel(String pos, int channel) {
        this.saveData.setTransmitterChannel(pos, channel);
        this.saveData.func_76185_a();
    }

    public void setTransmitterWeakSignal(BlockPos pos, int signal) {
        this.setTransmitterWeakSignal(ChannelData.getStringFromPos(pos), signal);
    }

    public void setTransmitterWeakSignal(BlockPos pos, int cellIndex, int signal) {
        this.setTransmitterWeakSignal(ChannelData.getStringFromPos(pos) + ", " + cellIndex, signal);
    }

    private void setTransmitterWeakSignal(String pos, int signal) {
        this.saveData.weakSignalMap.put(pos, signal);
        this.saveData.func_76185_a();
    }

    public void setTransmitterStrongSignal(BlockPos pos, int signal) {
        this.setTransmitterStrongSignal(ChannelData.getStringFromPos(pos), signal);
    }

    public void setTransmitterStrongSignal(BlockPos pos, int cellIndex, int signal) {
        this.setTransmitterStrongSignal(ChannelData.getStringFromPos(pos) + ", " + cellIndex, signal);
    }

    private void setTransmitterStrongSignal(String pos, int signal) {
        this.saveData.strongSignalMap.put(pos, signal);
        this.saveData.func_76185_a();
    }

    public Map<String, Integer> getChannelSignal(int channel, BlockPos pos) {
        HashMap<String, Integer> signals = new HashMap<String, Integer>();
        signals.put("strong", 0);
        signals.put("weak", 0);
        if (this.saveData.channelPosMap.containsKey(channel)) {
            for (String tPos : this.saveData.channelPosMap.get(channel)) {
                int range;
                int[] tPosValues = ChannelData.getXYZiFromPosString(tPos);
                int x = tPosValues[0];
                int y = tPosValues[1];
                int z = tPosValues[2];
                boolean isCell = tPosValues.length == 4;
                int n = range = isCell ? ((Integer)Config.RANGE_CELL.get()).intValue() : ((Integer)Config.RANGE_BLOCK.get()).intValue();
                if (Math.abs(x - pos.func_177958_n()) > range || Math.abs(y - pos.func_177956_o()) > range || Math.abs(z - pos.func_177952_p()) > range) continue;
                Integer sSignal = this.saveData.strongSignalMap.get(tPos);
                Integer wSignal = this.saveData.weakSignalMap.get(tPos);
                if (sSignal != null && sSignal > (Integer)signals.get("strong")) {
                    signals.put("strong", sSignal);
                }
                if (wSignal == null || wSignal <= (Integer)signals.get("weak")) continue;
                signals.put("weak", wSignal);
            }
        }
        return signals;
    }

    public void removeTransmitter(BlockPos pos) {
        this.removeTransmitter(ChannelData.getStringFromPos(pos));
    }

    public void removeTransmitter(BlockPos pos, int cellIndex) {
        this.removeTransmitter(ChannelData.getStringFromPos(pos) + ", " + cellIndex);
    }

    private void removeTransmitter(String pos) {
        Integer channel = this.saveData.getTransmitterChannel(pos);
        if (channel != null) {
            this.saveData.channelPosMap.get(channel).remove(pos);
        }
        this.saveData.strongSignalMap.remove(pos);
        this.saveData.weakSignalMap.remove(pos);
        this.saveData.func_76185_a();
    }

    public void cleanupTransmitters(IBlockReader blockGetter) {
        for (Map.Entry<Integer, List<String>> entry : this.saveData.channelPosMap.entrySet()) {
            for (String posString : entry.getValue()) {
                int[] coords = ChannelData.getXYZiFromPosString(posString);
                BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
                TileEntity blockEntity = blockGetter.func_175625_s(pos);
                if (ModList.get().isLoaded("tinyredstone") && coords.length == 4 && blockEntity instanceof PanelTile) {
                    PanelCellPos panelCellPos = PanelCellPos.fromIndex((PanelTile)((PanelTile)blockEntity), (Integer)coords[3]);
                    IPanelCell panelCell = panelCellPos.getIPanelCell();
                    if (panelCell instanceof TransmitterCell) {
                        ((TransmitterCell)panelCell).setChannel(entry.getKey());
                        continue;
                    }
                    this.removeTransmitter(posString);
                    continue;
                }
                if (blockEntity instanceof TransmitterBlockEntity) {
                    ((TransmitterBlockEntity)blockEntity).setChannel(entry.getKey());
                    continue;
                }
                this.removeTransmitter(posString);
            }
        }
        this.saveData.func_76185_a();
    }

    public CompoundNBT getChannelNBT() {
        CompoundNBT nbt = this.saveData.func_189551_b(new CompoundNBT());
        return nbt.func_74775_l("channeldata");
    }

    public static int[] getXYZiFromPosString(String pos) {
        String[] posArray = pos.split(",\\s+");
        int[] posArrayInt = new int[posArray.length];
        for (int i = 0; i < posArray.length; ++i) {
            posArrayInt[i] = Integer.parseInt(posArray[i]);
        }
        return posArrayInt;
    }

    private static String getStringFromPos(BlockPos pos) {
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }

    private static class ChannelSaveData
    extends WorldSavedData {
        public Map<Integer, List<String>> channelPosMap = new HashMap<Integer, List<String>>();
        public Map<String, Integer> weakSignalMap = new HashMap<String, Integer>();
        public Map<String, Integer> strongSignalMap = new HashMap<String, Integer>();

        public ChannelSaveData() {
            super("rangedwirelessredstone");
        }

        public void func_76184_a(CompoundNBT nbt) {
            CompoundNBT channelData = nbt.func_74775_l("channeldata");
            CompoundNBT signalData = nbt.func_74775_l("signaldata");
            CompoundNBT weakSignalData = nbt.func_74775_l("weaksignaldata");
            for (String key : channelData.func_150296_c()) {
                int channel = channelData.func_74762_e(key);
                if (!this.channelPosMap.containsKey(channel)) {
                    this.channelPosMap.put(channel, new ArrayList());
                }
                this.channelPosMap.get(channel).add(key);
                this.strongSignalMap.put(key, signalData.func_74762_e(key));
                this.weakSignalMap.put(key, weakSignalData.func_74762_e(key));
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            CompoundNBT channelData = new CompoundNBT();
            CompoundNBT strongSignalData = new CompoundNBT();
            CompoundNBT weakSignalData = new CompoundNBT();
            for (Map.Entry<Integer, List<String>> entry : this.channelPosMap.entrySet()) {
                for (String pos : entry.getValue()) {
                    channelData.func_74768_a(pos, entry.getKey().intValue());
                }
            }
            for (Map.Entry<Object, Object> entry : this.strongSignalMap.entrySet()) {
                strongSignalData.func_74768_a((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            for (Map.Entry<Object, Object> entry : this.weakSignalMap.entrySet()) {
                weakSignalData.func_74768_a((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            nbt.func_218657_a("channeldata", (INBT)channelData);
            nbt.func_218657_a("signaldata", (INBT)strongSignalData);
            nbt.func_218657_a("weaksignaldata", (INBT)weakSignalData);
            return nbt;
        }

        public void setTransmitterChannel(String pos, int channel) {
            Integer oldChannel = this.getTransmitterChannel(pos);
            if (oldChannel != null) {
                this.channelPosMap.get(oldChannel).remove(pos);
            }
            if (!this.channelPosMap.containsKey(channel)) {
                this.channelPosMap.put(channel, new ArrayList());
            }
            this.channelPosMap.get(channel).add(pos);
        }

        @CheckForNull
        public Integer getTransmitterChannel(String pos) {
            for (Map.Entry<Integer, List<String>> entry : this.channelPosMap.entrySet()) {
                if (!entry.getValue().contains(pos)) continue;
                return entry.getKey();
            }
            return null;
        }
    }
}

