/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.gui;

import com.dannyandson.rangedwirelessredstone.Config;
import com.dannyandson.rangedwirelessredstone.gui.ModWidget;
import com.dannyandson.rangedwirelessredstone.logic.ChannelData;
import com.dannyandson.rangedwirelessredstone.network.ModNetworkHandler;
import com.dannyandson.rangedwirelessredstone.network.ServerNetworkTrigger;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NetworkViewerGUI
extends Screen {
    private static final int WIDTH = 150;
    private static final int HEIGHT = 250;
    private static final ResourceLocation GUI = new ResourceLocation("rangedwirelessredstone", "textures/gui/transparent.png");
    private int relX;
    private int relY;
    private final CompoundNBT networkNBT;
    private List<String> channelList;
    private List<String> positionList;
    private int scrollIndex;
    private List<ModWidget> listWidgets;

    protected NetworkViewerGUI(CompoundNBT networkNBT) {
        super((ITextComponent)new TranslationTextComponent("rangedwirelessredstone:networkViewerGUI"));
        this.relX = (this.field_230708_k_ - 150) / 2;
        this.relY = (this.field_230709_l_ - 250) / 2;
        this.channelList = new ArrayList<String>();
        this.positionList = new ArrayList<String>();
        this.scrollIndex = 0;
        this.listWidgets = new ArrayList<ModWidget>();
        this.networkNBT = networkNBT;
    }

    protected void func_231160_c_() {
        this.relX = (this.field_230708_k_ - 150) / 2;
        this.relY = (this.field_230709_l_ - 250) / 2;
        this.func_230480_a_(new ModWidget(this.relX - 1, this.relY - 1, 152, 252, -1442840576));
        this.func_230480_a_(new ModWidget(this.relX, this.relY, 150, 250, -1997607186));
        this.func_230480_a_(new ModWidget(this.relX + 4, this.relY + 15, 142, 1, -1442840576));
        this.func_230480_a_(new ModWidget(this.relX + 4, this.relY + 15, 1, 204, -1440603614));
        this.func_230480_a_(new ModWidget(this.relX + 4, this.relY + 16 + 250 - 48, 142, 1, -1426063361));
        this.func_230480_a_(new ModWidget(this.relX + 5 + 150 - 10, this.relY + 15, 1, 204, -1428300323));
        this.func_230480_a_(new ModWidget(this.relX + 5, this.relY + 16, 140, 202, 0x66888888));
        this.func_230480_a_(new ModWidget(this.relX + 5, this.relY + 5, 140, 12, ITextComponent.func_244388_a((String)"Transmitter xyz(i)")));
        this.func_230480_a_(new ModWidget(this.relX + 105, this.relY + 5, 140, 12, ITextComponent.func_244388_a((String)"Channel")));
        HashMap networkList = new HashMap();
        for (String key : this.networkNBT.func_150296_c()) {
            int channel = this.networkNBT.func_74762_e(key);
            if (!networkList.containsKey(channel)) {
                networkList.put(channel, new ArrayList());
            }
            ((List)networkList.get(channel)).add(key);
        }
        BlockPos queryBlock = null;
        if (this.field_230706_i_.field_71476_x != null && this.field_230706_i_.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockhitresult = (BlockRayTraceResult)this.field_230706_i_.field_71476_x;
            queryBlock = blockhitresult.func_216350_a();
        }
        int index = 0;
        for (Object obj : networkList.keySet().stream().sorted().toArray()) {
            Integer channel = (Integer)obj;
            for (Object posObj : ((List)networkList.get(channel)).stream().sorted().toArray()) {
                String posString = (String)posObj;
                int[] tPosValues = ChannelData.getXYZiFromPosString(posString);
                int x = tPosValues[0];
                int y = tPosValues[1];
                int z = tPosValues[2];
                boolean isCell = tPosValues.length == 4;
                int range = isCell ? ((Integer)Config.RANGE_CELL.get()).intValue() : ((Integer)Config.RANGE_BLOCK.get()).intValue();
                boolean inRange = queryBlock != null && Math.abs(x - queryBlock.func_177958_n()) <= range && Math.abs(y - queryBlock.func_177956_o()) <= range && Math.abs(z - queryBlock.func_177952_p()) <= range;
                this.channelList.add(index, channel.toString());
                this.positionList.add(index, (inRange ? "\u2714" : "\u2043 ") + posString);
                ++index;
            }
        }
        this.setWidgetList();
        this.func_230480_a_((Widget)new Button(this.relX + 150 - 70, this.relY + 250 - 25, 50, 20, (ITextComponent)new TranslationTextComponent("rangedwirelessredstone.gui.close"), button -> this.close()));
        if (this.field_230706_i_.field_71439_g.func_211513_k(2)) {
            this.func_230480_a_((Widget)new Button(this.relX + 20, this.relY + 250 - 25, 50, 20, ITextComponent.func_244388_a((String)"Clean Up"), button -> this.cleanUpNetwork()));
        }
    }

    private void setWidgetList() {
        for (ModWidget modWidget : this.listWidgets) {
            this.field_230710_m_.remove((Object)modWidget);
        }
        this.listWidgets.clear();
        int wY = this.relY + 18;
        for (int i = 0; i + this.scrollIndex < this.channelList.size() && i < 20; ++i) {
            this.listWidgets.add(new ModWidget(this.relX + 10, wY, 100, 12, ITextComponent.func_244388_a((String)this.positionList.get(i + this.scrollIndex))));
            this.listWidgets.add(new ModWidget(this.relX + 105, wY, 40, 12, ITextComponent.func_244388_a((String)this.channelList.get(i + this.scrollIndex))).setTextHAlignment(ModWidget.HAlignment.CENTER));
            wY += 10;
        }
        for (ModWidget modWidget : this.listWidgets) {
            this.func_230480_a_(modWidget);
        }
    }

    public boolean func_231043_a_(double p_94686_, double p_94687_, double p_94688_) {
        if (p_94688_ > 0.0) {
            if (this.scrollIndex > 0) {
                --this.scrollIndex;
                this.setWidgetList();
                return true;
            }
        } else if (this.scrollIndex < this.channelList.size() - 20) {
            ++this.scrollIndex;
            this.setWidgetList();
            return true;
        }
        return false;
    }

    private void close() {
        this.field_230706_i_.func_147108_a(null);
    }

    private void cleanUpNetwork() {
        ModNetworkHandler.sendToServer(new ServerNetworkTrigger(ServerNetworkTrigger.ServerTrigger.CLEANUP));
        this.close();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI);
        int relX = (this.field_230708_k_ - 150) / 2;
        int relY = (this.field_230709_l_ - 250) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, 150, 250);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public static void open(CompoundNBT networkNBT) {
        Minecraft.func_71410_x().func_147108_a((Screen)new NetworkViewerGUI(networkNBT));
    }
}

