/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.compat.hwyla;

import com.dannyandson.rangedwirelessredstone.blocks.AbstractWirelessEntity;
import com.dannyandson.rangedwirelessredstone.compat.hwyla.TooltipRendererInfoString;
import com.dannyandson.rangedwirelessredstone.compat.hwyla.TooltipRendererItemStackInline;
import com.dannyandson.rangedwirelessredstone.compat.hwyla.TooltipRendererString;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.RenderableTextComponent;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.loading.FMLEnvironment;

@WailaPlugin(value="rangedwirelessredstone")
public class InfoProvider
implements IWailaPlugin,
IComponentProvider {
    static final ResourceLocation RENDER_STRING = new ResourceLocation("string");
    static final ResourceLocation RENDER_ITEM_INLINE = new ResourceLocation("item_inline");
    static final ResourceLocation RENDER_INFO_STRING = new ResourceLocation("info_string");

    public void register(IRegistrar registrar) {
        if (FMLEnvironment.dist.isClient()) {
            registrar.registerTooltipRenderer(RENDER_STRING, (ITooltipRenderer)new TooltipRendererString());
            registrar.registerTooltipRenderer(RENDER_ITEM_INLINE, (ITooltipRenderer)new TooltipRendererItemStackInline());
            registrar.registerTooltipRenderer(RENDER_INFO_STRING, (ITooltipRenderer)new TooltipRendererInfoString());
        }
        registrar.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, AbstractWirelessEntity.class);
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() != null) {
            BlockPos pos = accessor.getPosition();
            TileEntity tileEntity = accessor.getWorld().func_175625_s(pos);
            if (tileEntity instanceof AbstractWirelessEntity) {
                AbstractWirelessEntity wirelessEntity = (AbstractWirelessEntity)tileEntity;
                tooltip.add((ITextComponent)new RenderableTextComponent(new RenderableTextComponent[]{InfoProvider.getStringRenderable("Channel: " + wirelessEntity.getChannel())}));
                tooltip.add((ITextComponent)new RenderableTextComponent(new RenderableTextComponent[]{InfoProvider.getItemStackRenderable(new ItemStack((IItemProvider)Items.field_151137_ax)), InfoProvider.getStringRenderable("Signal: " + wirelessEntity.getWeakSignal())}));
            }
        }
    }

    public static RenderableTextComponent getItemStackRenderable(ItemStack itemStack) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", itemStack.func_77973_b().getRegistryName().toString());
        return new RenderableTextComponent(RENDER_ITEM_INLINE, tag);
    }

    public static RenderableTextComponent getStringRenderable(String string) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("string", string);
        return new RenderableTextComponent(RENDER_STRING, tag);
    }

    public static RenderableTextComponent getInfoStringRenderable(String string) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("string", string);
        return new RenderableTextComponent(RENDER_INFO_STRING, tag);
    }
}

