/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.blocks.tinyredstonecells;

import com.dannyandson.rangedwirelessredstone.RenderHelper;
import com.dannyandson.rangedwirelessredstone.blocks.tinyredstonecells.AbstractWirelessCell;
import com.dannyandson.rangedwirelessredstone.logic.ChannelData;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TransmitterCell
extends AbstractWirelessCell {
    boolean flagResetChannel = true;

    public void render(MatrixStack poseStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        RenderHelper.drawQuarterSlab(poseStack, builder, RenderHelper.SPRITE_PANEL_LIGHT, RenderHelper.SPRITE_PANEL_DARK, combinedLight, alpha);
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, 0.0, 0.325);
        RenderHelper.drawRectangle(builder, poseStack, 0.25f, 0.75f, 0.25f, 0.75f, RenderHelper.SPRITE_PANEL_DARK, combinedLight, combinedOverlay);
        poseStack.func_227861_a_(0.0, 0.0, 0.55);
        RenderHelper.drawRectangle(builder, poseStack, 0.4375f, 0.5625f, 0.4375f, 0.5625f, RenderHelper.SPRITE_PANEL_RED, combinedLight, combinedOverlay);
        poseStack.func_227865_b_();
        poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, 0.0, -0.25);
        this.drawSide(poseStack, builder, combinedLight, combinedOverlay);
        poseStack.func_227865_b_();
        poseStack.func_227860_a_();
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        poseStack.func_227861_a_(0.0, 0.0, 0.75);
        this.drawSide(poseStack, builder, combinedLight, combinedOverlay);
        poseStack.func_227865_b_();
        poseStack.func_227860_a_();
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        poseStack.func_227861_a_(-1.0, 0.0, 0.75);
        this.drawSide(poseStack, builder, combinedLight, combinedOverlay);
        poseStack.func_227865_b_();
        poseStack.func_227860_a_();
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        poseStack.func_227861_a_(-1.0, 0.0, -0.25);
        this.drawSide(poseStack, builder, combinedLight, combinedOverlay);
        poseStack.func_227865_b_();
    }

    private void drawSide(MatrixStack poseStack, IVertexBuilder builder, int combinedLight, int combinedOverlay) {
        RenderHelper.drawRectangle(builder, poseStack, 0.25f, 0.75f, 0.25f, 0.325f, RenderHelper.SPRITE_PANEL_DARK, combinedLight, combinedOverlay);
        poseStack.func_227861_a_(0.0, 0.0, -0.1875);
        RenderHelper.drawRectangle(builder, poseStack, 0.4375f, 0.5625f, 0.3125f, 0.75f, RenderHelper.SPRITE_PANEL_LIGHT, combinedLight, combinedOverlay);
        RenderHelper.drawRectangle(builder, poseStack, 0.4375f, 0.5625f, 0.75f, 0.875f, RenderHelper.SPRITE_PANEL_RED, combinedLight, combinedOverlay);
    }

    public boolean onPlace(PanelCellPos cellPos, PlayerEntity player) {
        this.panelCellPos = cellPos;
        World world = cellPos.getPanelTile().func_145831_w();
        if (world instanceof ServerWorld) {
            ChannelData.getChannelData((ServerWorld)world).setTransmitterChannel(cellPos.getPanelTile().func_174877_v(), cellPos.getIndex(), this.getChannel());
        }
        return this.neighborChanged(cellPos);
    }

    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        int sSignal = 0;
        int wSignal = 0;
        if (frontNeighbor != null) {
            sSignal = frontNeighbor.getStrongRsOutput();
            wSignal = frontNeighbor.getWeakRsOutput();
        }
        if (rightNeighbor != null) {
            sSignal = Math.max(sSignal, rightNeighbor.getStrongRsOutput());
            wSignal = Math.max(wSignal, rightNeighbor.getWeakRsOutput());
        }
        if (backNeighbor != null) {
            sSignal = Math.max(sSignal, backNeighbor.getStrongRsOutput());
            wSignal = Math.max(wSignal, backNeighbor.getWeakRsOutput());
        }
        if (leftNeighbor != null) {
            sSignal = Math.max(sSignal, leftNeighbor.getStrongRsOutput());
            wSignal = Math.max(wSignal, leftNeighbor.getWeakRsOutput());
        }
        if (bottomNeighbor != null) {
            sSignal = Math.max(sSignal, bottomNeighbor.getStrongRsOutput());
            wSignal = Math.max(wSignal, bottomNeighbor.getWeakRsOutput());
        }
        if (sSignal != this.getStrongSignal() || wSignal != this.getWeakSignal()) {
            if (cellPos.getPanelTile().func_145831_w() instanceof ServerWorld) {
                ServerWorld serverLevel = (ServerWorld)cellPos.getPanelTile().func_145831_w();
                ChannelData.getChannelData(serverLevel).setTransmitterStrongSignal(cellPos.getPanelTile().func_174877_v(), cellPos.getIndex(), sSignal);
                ChannelData.getChannelData(serverLevel).setTransmitterWeakSignal(cellPos.getPanelTile().func_174877_v(), cellPos.getIndex(), wSignal);
            }
            this.setSignals(wSignal, sSignal);
        }
        return false;
    }

    public int getWeakRsOutput(Side side) {
        return 0;
    }

    public int getStrongRsOutput(Side side) {
        return 0;
    }

    public boolean tick(PanelCellPos cellPos) {
        if (this.panelCellPos != null && this.panelCellPos.getIndex() != cellPos.getIndex()) {
            this.onRemove(this.panelCellPos);
            this.flagResetChannel = true;
        }
        if (this.flagResetChannel) {
            this.panelCellPos = cellPos;
            if (cellPos.getPanelTile().func_145831_w() instanceof ServerWorld) {
                ServerWorld serverLevel = (ServerWorld)cellPos.getPanelTile().func_145831_w();
                ChannelData.getChannelData(serverLevel).setTransmitterChannel(cellPos.getPanelTile().func_174877_v(), cellPos.getIndex(), this.getChannel());
                ChannelData.getChannelData(serverLevel).setTransmitterStrongSignal(cellPos.getPanelTile().func_174877_v(), cellPos.getIndex(), this.getStrongSignal());
                ChannelData.getChannelData(serverLevel).setTransmitterWeakSignal(cellPos.getPanelTile().func_174877_v(), cellPos.getIndex(), this.getWeakSignal());
            }
            this.flagResetChannel = false;
        }
        return false;
    }

    @Override
    public void setChannel(int channel) {
        if (this.panelCellPos != null && channel != this.getChannel()) {
            World world = this.panelCellPos.getPanelTile().func_145831_w();
            if (world instanceof ServerWorld) {
                ChannelData.getChannelData((ServerWorld)world).setTransmitterChannel(this.panelCellPos.getPanelTile().func_174877_v(), this.panelCellPos.getIndex(), channel);
            }
            super.setChannel(channel);
        }
    }

    public void onRemove(PanelCellPos cellPos) {
        World world = cellPos.getPanelTile().func_145831_w();
        if (world instanceof ServerWorld) {
            ChannelData.getChannelData((ServerWorld)world).removeTransmitter(cellPos.getPanelTile().func_174877_v(), cellPos.getIndex());
        }
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell posInPanelCell) {
        overlayBlockInfo.addText("Signal", this.getWeakSignal() + "");
        super.addInfo(overlayBlockInfo, panelTile, posInPanelCell);
    }
}

