/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.blocks.tinyredstonecells;

import com.dannyandson.rangedwirelessredstone.gui.ChannelSelectGUI;
import com.dannyandson.rangedwirelessredstone.logic.IWirelessComponent;
import com.dannyandson.rangedwirelessredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.network.PanelCellSync;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractWirelessCell
implements IWirelessComponent,
IPanelCell,
IPanelCellInfoProvider {
    private int strongSignal = 0;
    private int weakSignal = 0;
    private int channel = 0;
    protected PanelCellPos panelCellPos = null;

    public boolean needsSolidBase() {
        return true;
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compoundTag = new CompoundNBT();
        compoundTag.func_74768_a("signal", this.strongSignal);
        compoundTag.func_74768_a("weaksignal", this.weakSignal);
        compoundTag.func_74768_a("channel", this.channel);
        return compoundTag;
    }

    public void readNBT(CompoundNBT compoundTag) {
        this.strongSignal = compoundTag.func_74762_e("signal");
        this.weakSignal = compoundTag.func_74762_e("weaksignal");
        this.channel = compoundTag.func_74762_e("channel");
    }

    public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.QUARTERCELLSLAB;
    }

    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell posInPanelCell) {
        overlayBlockInfo.addText("Channel", this.channel + "");
    }

    @Override
    public int getStrongSignal() {
        return this.strongSignal;
    }

    @Override
    public int getWeakSignal() {
        return this.weakSignal;
    }

    @Override
    public void setSignals(int weak, int strong) {
        this.weakSignal = weak;
        this.strongSignal = strong;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
        if (this.panelCellPos != null && !this.panelCellPos.getPanelTile().func_145831_w().field_72995_K) {
            ModNetworkHandler.sendToClient((Object)new PanelCellSync(this.panelCellPos.getPanelTile().func_174877_v(), this.panelCellPos.getIndex(), this.writeNBT()), this.panelCellPos.getPanelTile());
        }
    }

    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        this.panelCellPos = cellPos;
        if (cellPos.getPanelTile().func_145831_w().func_201670_d()) {
            ChannelSelectGUI.open(this);
        }
        return super.onBlockActivated(cellPos, segmentClicked, player);
    }

    public boolean hasActivation() {
        return true;
    }

    @Override
    public BlockPos getPos() {
        if (this.panelCellPos != null) {
            return this.panelCellPos.getPanelTile().func_174877_v();
        }
        return null;
    }

    @Override
    public Integer getCellIndex() {
        if (this.panelCellPos != null) {
            return this.panelCellPos.getIndex();
        }
        return null;
    }
}

