/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.blocks;

import com.dannyandson.rangedwirelessredstone.blocks.TransmitterBlockEntity;
import com.dannyandson.rangedwirelessredstone.gui.ChannelSelectGUI;
import com.dannyandson.rangedwirelessredstone.logic.ChannelData;
import com.dannyandson.rangedwirelessredstone.logic.IWirelessComponent;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TransmitterBlock
extends Block {
    private static final VoxelShape shape = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0)), (VoxelShape)Block.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));

    public TransmitterBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200943_b(2.0f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TransmitterBlockEntity();
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public void func_220082_b(BlockState blockState, World level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        TileEntity te = level.func_175625_s(pos);
        if (level instanceof ServerWorld && te instanceof TransmitterBlockEntity) {
            ServerWorld serverLevel = (ServerWorld)level;
            TransmitterBlockEntity transmitterEntity = (TransmitterBlockEntity)te;
            ChannelData.getChannelData(serverLevel).setTransmitterChannel(pos, 0);
            ChannelData.getChannelData(serverLevel).setTransmitterStrongSignal(pos, 0);
            int direct = level.func_175676_y(pos);
            int indirect = level.func_175687_A(pos);
            transmitterEntity.setSignals(indirect, direct);
        }
    }

    public void func_196243_a(BlockState blockState, World level, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        if (level instanceof ServerWorld) {
            ChannelData.getChannelData((ServerWorld)level).removeTransmitter(pos);
        }
        super.func_196243_a(blockState, level, pos, p_60518_, p_60519_);
    }

    public void func_220069_a(BlockState blockState, World level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof TransmitterBlockEntity) {
            if (level instanceof ServerWorld) {
                int direct = level.func_175676_y(pos);
                int indirect = level.func_175687_A(pos);
                ((TransmitterBlockEntity)te).setSignals(indirect, direct);
            }
        } else {
            super.func_220069_a(blockState, level, pos, block, neighborPos, isMoving);
        }
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockHitResult) {
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof IWirelessComponent) {
            if (level.func_201670_d()) {
                ChannelSelectGUI.open((IWirelessComponent)te);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(blockState, level, pos, player, hand, blockHitResult);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return shape;
    }
}

