/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.rangedwirelessredstone.blocks;

import com.dannyandson.rangedwirelessredstone.blocks.ReceiverBlockEntity;
import com.dannyandson.rangedwirelessredstone.gui.ChannelSelectGUI;
import com.dannyandson.rangedwirelessredstone.logic.IWirelessComponent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ReceiverBlock
extends Block {
    private static final VoxelShape shape = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)2.0, (double)4.0, (double)4.0, (double)12.0, (double)5.0)), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)13.0, (double)14.0, (double)5.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)4.0, (double)4.0, (double)14.0, (double)5.0)));
    private static final Map<Direction, VoxelShape> shapeMap = new HashMap<Direction, VoxelShape>();

    public ReceiverBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200943_b(2.0f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ReceiverBlockEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)context.func_195992_f());
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean func_149744_f(BlockState p_60571_) {
        return true;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockGetter, BlockPos pos, Direction direction) {
        TileEntity te = blockGetter.func_175625_s(pos);
        if (te instanceof IWirelessComponent) {
            return ((IWirelessComponent)te).getStrongSignal();
        }
        return super.func_176211_b(blockState, blockGetter, pos, direction);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockGetter, BlockPos pos, Direction direction) {
        TileEntity tileEntity = blockGetter.func_175625_s(pos);
        if (tileEntity instanceof IWirelessComponent) {
            IWirelessComponent component = (IWirelessComponent)tileEntity;
            return component.getWeakSignal();
        }
        return super.func_180656_a(blockState, blockGetter, pos, direction);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockHitResult) {
        TileEntity te = level.func_175625_s(pos);
        if (level.func_175625_s(pos) instanceof IWirelessComponent) {
            if (level.func_201670_d()) {
                ChannelSelectGUI.open((IWirelessComponent)te);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(blockState, level, pos, player, hand, blockHitResult);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        VoxelShape thisShape = shapeMap.get(blockState.func_177229_b((Property)BlockStateProperties.field_208155_H));
        if (thisShape != null) {
            return thisShape;
        }
        return shape;
    }

    private static VoxelShape rotateShape(Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (direction.func_176736_b() - Direction.NORTH.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX)));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        return buffer[0];
    }

    static {
        shapeMap.put(Direction.NORTH, shape);
        shapeMap.put(Direction.EAST, ReceiverBlock.rotateShape(Direction.EAST));
        shapeMap.put(Direction.SOUTH, ReceiverBlock.rotateShape(Direction.SOUTH));
        shapeMap.put(Direction.WEST, ReceiverBlock.rotateShape(Direction.WEST));
    }
}

