/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.createchunkloading.misc;

import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import org.embeddedt.createchunkloading.CreateChunkloading;
import org.embeddedt.createchunkloading.blocks.ChunkLoader;

public class ChunkLoaderMovementBehaviour
extends MovementBehaviour {
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.field_72995_K) {
            return;
        }
        pos = new BlockPos(context.contraption.entity.field_70176_ah, 0, context.contraption.entity.field_70164_aj);
        CreateChunkloading.logger.debug("visit new position " + pos.toString());
        Object oldPos = context.temporaryData;
        if (!(oldPos instanceof BlockPos) && context.data.func_74764_b("previous_chunk")) {
            oldPos = BlockPos.func_218283_e((long)context.data.func_74763_f("previous_chunk"));
        }
        if (pos.equals(oldPos)) {
            return;
        }
        if (oldPos instanceof BlockPos) {
            BlockPos oldChunkPos = (BlockPos)oldPos;
            ChunkLoader.forgeLoadChunk((ServerWorld)context.world, oldChunkPos.func_177958_n(), oldChunkPos.func_177952_p(), false, context.contraption.entity.func_110124_au(), true);
        }
        ChunkLoader.forgeLoadChunk((ServerWorld)context.world, context.contraption.entity.field_70176_ah, context.contraption.entity.field_70164_aj, true, context.contraption.entity.func_110124_au(), true);
        context.temporaryData = pos;
    }

    public static BlockPos getBlockPos(Vector3d vec) {
        return new BlockPos((int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c);
    }

    public void startMoving(MovementContext context) {
        if (context.position == null) {
            return;
        }
        context.temporaryData = context.contraption.entity.func_233580_cy_();
        CreateChunkloading.logger.debug("start moving " + context.temporaryData.toString());
        ChunkLoader.forgeLoadChunk((ServerWorld)context.world, context.contraption.entity.field_70176_ah, context.contraption.entity.field_70164_aj, true, context.contraption.entity.func_110124_au(), true);
    }

    public void stopMoving(MovementContext context) {
        if (context.contraption.entity == null) {
            CreateChunkloading.logger.error("Contraption entity no longer exists - a chunk is probably going to remain loaded forever!");
            return;
        }
        BlockPos pos = context.contraption.entity.func_233580_cy_();
        CreateChunkloading.logger.debug("stop moving " + pos.toString());
        ChunkLoader.forgeLoadChunk((ServerWorld)context.world, context.contraption.entity.field_70176_ah, context.contraption.entity.field_70164_aj, false, context.contraption.entity.func_110124_au(), true);
        context.temporaryData = null;
    }

    public void writeExtraData(MovementContext context) {
        super.writeExtraData(context);
        if (context.temporaryData instanceof BlockPos) {
            context.data.func_74772_a("previous_chunk", ((BlockPos)context.temporaryData).func_218275_a());
            CreateChunkloading.logger.debug("previous chunk saved");
        } else {
            CreateChunkloading.logger.debug("i don't want to write null");
        }
    }
}

