/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.createchunkloading.misc;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import org.embeddedt.createchunkloading.Config;
import org.embeddedt.createchunkloading.CreateChunkloading;
import org.embeddedt.createchunkloading.misc.IChunkLoaderList;
import org.embeddedt.createchunkloading.misc.iVec2d;

public class ChunkLoaderList
implements IChunkLoaderList {
    @Nullable
    private final ServerWorld world;
    public HashMap<iVec2d, Integer> loadedchunks;
    public ArrayList<BlockPos> chunkloaderblocks;
    private boolean enabled = false;

    public ChunkLoaderList(@Nullable ServerWorld world) {
        this.world = world;
        this.loadedchunks = new HashMap();
        this.chunkloaderblocks = new ArrayList();
    }

    private void force(BlockPos pos) {
        this.forceload(pos, "add");
    }

    private void unforce(BlockPos pos) {
        this.forceload(pos, "remove");
    }

    private void forceload(BlockPos pos, String action) {
        if (this.world == null) {
            return;
        }
        CommandSource source = this.world.func_73046_m().func_195573_aM().func_201003_a(this.world);
        if (!((Boolean)Config.CHUNK_CHAT.get()).booleanValue()) {
            source = source.func_197031_a();
        }
        String cmd = "forceload " + action + " " + pos.func_177958_n() + " " + pos.func_177952_p();
        System.out.println(cmd);
        int ret = this.world.func_73046_m().func_195571_aL().func_197059_a(source, cmd);
    }

    private void setforceload(BlockPos pos, Boolean x) {
        this.forceload(pos, x != false ? "add" : "remove");
    }

    private void setforceload(iVec2d pos, Boolean x) {
        this.forceload(new BlockPos(pos.x, 0, pos.y), x != false ? "add" : "remove");
    }

    @Override
    public void addblock(BlockPos pos) {
        if (pos == null) {
            CreateChunkloading.logger.debug("pos is null");
            return;
        }
        iVec2d chunk = new iVec2d(pos);
        chunk.x >>= 4;
        chunk.y >>= 4;
        this.addchunk(chunk);
    }

    @Override
    public void removeblock(BlockPos pos) {
        if (pos == null) {
            CreateChunkloading.logger.debug("pos is null");
            return;
        }
        iVec2d chunk = new iVec2d(pos);
        chunk.x >>= 4;
        chunk.y >>= 4;
        this.removechunk(chunk);
    }

    @Override
    public void add(BlockPos pos) {
        if (pos == null) {
            CreateChunkloading.logger.debug("pos is null");
            return;
        }
        iVec2d chunk = new iVec2d(pos);
        chunk.x >>= 4;
        chunk.y >>= 4;
        this.addchunk(chunk);
    }

    @Override
    public void remove(BlockPos pos) {
        if (pos == null) {
            CreateChunkloading.logger.debug("pos is null");
            return;
        }
        iVec2d chunk = new iVec2d(pos);
        chunk.x >>= 4;
        chunk.y >>= 4;
        this.removechunk(chunk);
    }

    @Override
    public void addchunk(iVec2d chunk) {
        if (chunk == null) {
            CreateChunkloading.logger.debug("chunk is null");
            return;
        }
        if (!this.loadedchunks.containsKey(chunk)) {
            this.loadedchunks.put(chunk, 1);
            this.setforceload(chunk.times(16), (Boolean)true);
        } else {
            this.loadedchunks.put(chunk, this.loadedchunks.get(chunk) + 1);
        }
        CreateChunkloading.logger.debug(this.loadedchunks);
    }

    @Override
    public void removechunk(iVec2d chunk) {
        Integer i = this.loadedchunks.get(chunk);
        if (i == null) {
            CreateChunkloading.logger.debug("no chunk to remove");
            return;
        }
        if (chunk == null) {
            CreateChunkloading.logger.debug("chunk is null");
            return;
        }
        if (i == 1) {
            this.loadedchunks.remove(chunk);
            this.setforceload(chunk.times(16), (Boolean)false);
        } else {
            this.loadedchunks.put(chunk, i - 1);
        }
        CreateChunkloading.logger.debug(this.loadedchunks);
    }

    public void addSilent(BlockPos pos) {
    }

    @Override
    public void start() {
        this.enabled = true;
    }

    public void reload() {
        for (iVec2d k : this.loadedchunks.keySet()) {
            Integer i = this.loadedchunks.get(k);
            if (i == null || i == 0) {
                this.loadedchunks.remove(k);
                continue;
            }
            this.setforceload(k, (Boolean)true);
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        long[] keys = nbt.func_197645_o("loadedchunksKeys");
        int[] values = nbt.func_74759_k("loadedchunksValues");
        CreateChunkloading.logger.debug((Object)keys);
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] <= 0) continue;
            this.loadedchunks.put(new iVec2d(keys[i]), values[i]);
            CreateChunkloading.logger.debug(new iVec2d(keys[i]).toString() + " = " + values[i]);
        }
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        long[] keys = new long[this.loadedchunks.size()];
        int[] values = new int[this.loadedchunks.size()];
        int i = 0;
        CreateChunkloading.logger.debug("writenbt");
        CreateChunkloading.logger.debug(this.loadedchunks.keySet());
        for (iVec2d v : this.loadedchunks.keySet()) {
            CreateChunkloading.logger.debug((Object)v);
            keys[i] = v.toLong();
            values[i] = this.loadedchunks.get(v);
            ++i;
        }
        nbt.func_197644_a("loadedchunksKeys", keys);
        nbt.func_74783_a("loadedchunksValues", values);
        return nbt;
    }

    public static class Storage
    implements Capability.IStorage<IChunkLoaderList> {
        public INBT writeNBT(Capability<IChunkLoaderList> capability, IChunkLoaderList instance, Direction side) {
            if (!(instance instanceof ChunkLoaderList)) {
                return null;
            }
            return ((ChunkLoaderList)instance).writeToNBT();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readNBT(Capability<IChunkLoaderList> capability, IChunkLoaderList instance, Direction side, INBT nbt) {
            if (!(instance instanceof ChunkLoaderList) || !(nbt instanceof CompoundNBT)) {
                return;
            }
            ChunkLoaderList list = (ChunkLoaderList)instance;
            try {
                list.readFromNBT((CompoundNBT)nbt);
                CreateChunkloading.logger.debug("Loaded Chunk Loader positions. sucsessfull");
            }
            finally {
                CreateChunkloading.logger.debug("Loaded Chunk Loader positions.");
            }
        }
    }
}

