/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.createchunkloading.blocks;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkLoader
extends Block {
    public ChunkLoader() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150461_bJ));
        this.setRegistryName("chunk_loader");
    }

    public void func_220082_b(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, world, pos, oldState, isMoving);
        if (world.field_72995_K) {
            return;
        }
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        ChunkLoader.forgeLoadChunk((ServerWorld)world, chunkX, chunkZ, true, pos, false);
    }

    public void func_196243_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (world.field_72995_K) {
            return;
        }
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        ChunkLoader.forgeLoadChunk((ServerWorld)world, chunkX, chunkZ, false, pos, false);
    }

    public static BlockPos roundBlockPosToChunk(BlockPos pos) {
        int roundedX = pos.func_177958_n() & 0xFFFFFFF0;
        int roundedZ = pos.func_177952_p() & 0xFFFFFFF0;
        return new BlockPos(roundedX, 0, roundedZ);
    }

    public static void forgeLoadChunk(ServerWorld world, int chunkX, int chunkZ, boolean state, Object entityUUID, boolean shouldLoadSurroundingAsWell) {
        if (entityUUID instanceof UUID) {
            ForgeChunkManager.forceChunk((ServerWorld)world, (String)"createchunkloading", (UUID)((UUID)entityUUID), (int)chunkX, (int)chunkZ, (boolean)state, (boolean)true);
        } else if (entityUUID instanceof BlockPos) {
            ForgeChunkManager.forceChunk((ServerWorld)world, (String)"createchunkloading", (BlockPos)((BlockPos)entityUUID), (int)chunkX, (int)chunkZ, (boolean)state, (boolean)true);
        } else {
            throw new IllegalArgumentException("entityUUID must be UUID or BlockPos");
        }
        if (shouldLoadSurroundingAsWell) {
            ChunkLoader.forgeLoadChunk(world, chunkX + 1, chunkZ, state, entityUUID, false);
            ChunkLoader.forgeLoadChunk(world, chunkX + 1, chunkZ + 1, state, entityUUID, false);
            ChunkLoader.forgeLoadChunk(world, chunkX + 1, chunkZ - 1, state, entityUUID, false);
            ChunkLoader.forgeLoadChunk(world, chunkX - 1, chunkZ, state, entityUUID, false);
            ChunkLoader.forgeLoadChunk(world, chunkX - 1, chunkZ + 1, state, entityUUID, false);
            ChunkLoader.forgeLoadChunk(world, chunkX - 1, chunkZ - 1, state, entityUUID, false);
            ChunkLoader.forgeLoadChunk(world, chunkX, chunkZ - 1, state, entityUUID, false);
            ChunkLoader.forgeLoadChunk(world, chunkX, chunkZ + 1, state, entityUUID, false);
        }
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.NORMAL;
    }

    public boolean hasTileEntity(BlockState state) {
        return false;
    }
}

