/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.createchunkloading;

import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.createchunkloading.Config;
import org.embeddedt.createchunkloading.blocks.ChunkLoader;
import org.embeddedt.createchunkloading.blocks.ModBlocks;
import org.embeddedt.createchunkloading.misc.ChunkLoaderMovementBehaviour;
import org.embeddedt.createchunkloading.misc.IChunkLoaderList;
import org.embeddedt.createchunkloading.setup.ModSetup;

@Mod(value="createchunkloading")
public class CreateChunkloading {
    public static final String modid = "createchunkloading";
    public static final String version = "0.2.0";
    public static final Logger logger = LogManager.getLogger((String)"createchunkloading");
    public static ModSetup setup = new ModSetup();
    public static CreateChunkloading instance;
    @CapabilityInject(value=IChunkLoaderList.class)
    public static Capability<IChunkLoaderList> CHUNK_LOADING_CAPABILITY;

    public CreateChunkloading() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("createchunkloading-common.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CreateChunkloading::clientInit);
    }

    public static Map<ResourceLocation, IRecipe<?>> getRecipes(IRecipeType<?> recipeType, RecipeManager manager) {
        Map recipesMap = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)manager, (String)"recipes");
        assert (recipesMap != null);
        return (Map)recipesMap.get(recipeType);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.CHUNK_LOADER, (RenderType)RenderType.func_228645_f_());
        CreateChunkloading.registerRenderers();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers() {
    }

    public static ResourceLocation generateResourceLocation(String resourceName) {
        return new ResourceLocation(modid, resourceName);
    }

    private void setup(FMLCommonSetupEvent event) {
        setup.init();
        logger.info("Setup method registered.");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        logger.info("Client method registered.");
    }

    static {
        CHUNK_LOADING_CAPABILITY = null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            logger.info("items registering");
            Item.Properties properties = new Item.Properties().func_200916_a(ModSetup.itemGroup);
            event.getRegistry().register(new BlockItem((Block)ModBlocks.CHUNK_LOADER, properties).setRegistryName("chunk_loader"));
            logger.info("finished items registering");
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            logger.info("blocks registering");
            ChunkLoader b = new ChunkLoader();
            event.getRegistry().register((IForgeRegistryEntry)b);
            AllMovementBehaviours.addMovementBehaviour((ResourceLocation)event.getRegistry().getKey((IForgeRegistryEntry)b), (MovementBehaviour)new ChunkLoaderMovementBehaviour());
            logger.info("finished blocks registering");
        }
    }
}

