/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class TurtleInventoryCrafting
extends CraftingInventory {
    private final ITurtleAccess turtle;
    private int xStart = 0;
    private int yStart = 0;

    public TurtleInventoryCrafting(ITurtleAccess turtle) {
        super(null, 0, 0);
        this.turtle = turtle;
    }

    @Nullable
    private IRecipe<CraftingInventory> tryCrafting(int xStart, int yStart) {
        this.xStart = xStart;
        this.yStart = yStart;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x >= this.xStart && x < this.xStart + 3 && y >= this.yStart && y < this.yStart + 3 || this.turtle.getInventory().func_70301_a(x + y * 4).func_190926_b()) continue;
                return null;
            }
        }
        return this.turtle.getWorld().func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this, this.turtle.getWorld()).orElse(null);
    }

    @Nullable
    public List<ItemStack> doCrafting(World world, int maxCount) {
        ItemStack result;
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return null;
        }
        IRecipe<CraftingInventory> recipe = this.tryCrafting(0, 0);
        if (recipe == null) {
            recipe = this.tryCrafting(0, 1);
        }
        if (recipe == null) {
            recipe = this.tryCrafting(1, 0);
        }
        if (recipe == null) {
            recipe = this.tryCrafting(1, 1);
        }
        if (recipe == null) {
            return null;
        }
        if (maxCount == 0) {
            return Collections.emptyList();
        }
        TurtlePlayer player = TurtlePlayer.get(this.turtle);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < maxCount && recipe.func_77569_a((IInventory)this, world) && !(result = recipe.func_77572_b((IInventory)this)).func_190926_b(); ++i) {
            results.add(result);
            result.func_77980_a(world, (PlayerEntity)player, result.func_190916_E());
            BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)result, (IInventory)this);
            ForgeHooks.setCraftingPlayer((PlayerEntity)player);
            NonNullList remainders = recipe.func_179532_b((IInventory)this);
            ForgeHooks.setCraftingPlayer(null);
            for (int slot = 0; slot < remainders.size(); ++slot) {
                ItemStack existing = this.func_70301_a(slot);
                ItemStack remainder = (ItemStack)remainders.get(slot);
                if (!existing.func_190926_b()) {
                    this.func_70298_a(slot, 1);
                    existing = this.func_70301_a(slot);
                }
                if (remainder.func_190926_b()) continue;
                if (existing.func_190926_b()) {
                    this.func_70299_a(slot, remainder);
                    continue;
                }
                if (ItemStack.func_179545_c((ItemStack)existing, (ItemStack)remainder) && ItemStack.func_77970_a((ItemStack)existing, (ItemStack)remainder)) {
                    remainder.func_190917_f(existing.func_190916_E());
                    this.func_70299_a(slot, remainder);
                    continue;
                }
                results.add(remainder);
            }
        }
        return results;
    }

    public int func_174922_i() {
        return 3;
    }

    public int func_174923_h() {
        return 3;
    }

    private int modifyIndex(int index) {
        int x = this.xStart + index % this.func_174922_i();
        int y = this.yStart + index / this.func_174923_h();
        return x >= 0 && x < 4 && y >= 0 && y < 4 ? x + y * 4 : -1;
    }

    public int func_70302_i_() {
        return this.func_174922_i() * this.func_174923_h();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().func_70301_a(i);
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().func_70304_b(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int size) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().func_70298_a(i, size);
    }

    public void func_70299_a(int i, @Nonnull ItemStack stack) {
        i = this.modifyIndex(i);
        this.turtle.getInventory().func_70299_a(i, stack);
    }

    public int func_70297_j_() {
        return this.turtle.getInventory().func_70297_j_();
    }

    public void func_70296_d() {
        this.turtle.getInventory().func_70296_d();
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack stack) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().func_94041_b(i, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            int j = this.modifyIndex(i);
            this.turtle.getInventory().func_70299_a(j, ItemStack.field_190927_a);
        }
    }
}

