/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class SpeakerPosition {
    private final World level;
    private final Vector3d position;
    private final Entity entity;

    private SpeakerPosition(@Nullable World level, @Nonnull Vector3d position, @Nullable Entity entity) {
        this.level = level;
        this.position = position;
        this.entity = entity;
    }

    public static SpeakerPosition of(@Nullable World level, @Nonnull Vector3d position) {
        return new SpeakerPosition(level, position, null);
    }

    public static SpeakerPosition of(@Nonnull Entity entity) {
        return new SpeakerPosition(entity.field_70170_p, entity.func_174824_e(1.0f), entity);
    }

    @Nullable
    public World level() {
        return this.level;
    }

    @Nonnull
    public Vector3d position() {
        return this.position;
    }

    @Nullable
    public Entity entity() {
        return this.entity;
    }

    public boolean withinDistance(SpeakerPosition other, double distanceSq) {
        return this.level == other.level && this.entity == other.entity && this.position.func_72436_e(other.position) <= distanceSq;
    }

    public Message asMessage() {
        if (this.level == null) {
            throw new NullPointerException("Cannot send a position without a level");
        }
        return new Message(this.level.func_234923_W_().getRegistryName(), this.position, this.entity == null ? OptionalInt.empty() : OptionalInt.of(this.entity.func_145782_y()));
    }

    public static final class Message {
        private final ResourceLocation level;
        private final Vector3d position;
        private final OptionalInt entity;

        private Message(ResourceLocation level, Vector3d position, OptionalInt entity) {
            this.level = level;
            this.position = position;
            this.entity = entity;
        }

        public static Message read(@Nonnull PacketBuffer buffer) {
            ResourceLocation level = buffer.func_192575_l();
            Vector3d position = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            OptionalInt entity = buffer.readBoolean() ? OptionalInt.of(buffer.readInt()) : OptionalInt.empty();
            return new Message(level, position, entity);
        }

        public void write(@Nonnull PacketBuffer buffer) {
            buffer.func_192572_a(this.level);
            buffer.writeDouble(this.position.field_72450_a);
            buffer.writeDouble(this.position.field_72448_b);
            buffer.writeDouble(this.position.field_72449_c);
            buffer.writeBoolean(this.entity.isPresent());
            if (this.entity.isPresent()) {
                buffer.writeInt(this.entity.getAsInt());
            }
        }

        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public SpeakerPosition reify() {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientWorld level = minecraft.field_71441_e;
            if (level != null && !level.func_234923_W_().getRegistryName().equals((Object)this.level)) {
                level = null;
            }
            return new SpeakerPosition((World)level, this.position, level != null && this.entity.isPresent() ? level.func_73045_a(this.entity.getAsInt()) : null);
        }
    }
}

