/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.ContainerHeldItem;
import dan200.computercraft.shared.network.container.HeldItemContainerData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ItemPrintout
extends Item {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_PAGES = "Pages";
    private static final String NBT_LINE_TEXT = "Text";
    private static final String NBT_LINE_COLOUR = "Color";
    public static final int LINES_PER_PAGE = 21;
    public static final int LINE_MAX_LENGTH = 25;
    public static final int MAX_PAGES = 16;
    private final Type type;

    public ItemPrintout(Item.Properties settings, Type type) {
        super(settings);
        this.type = type;
    }

    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag options) {
        String title = ItemPrintout.getTitle(stack);
        if (title != null && !title.isEmpty()) {
            list.add((ITextComponent)new StringTextComponent(title));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            new HeldItemContainerData(hand).open(player, new ContainerHeldItem.Factory((ContainerType<ContainerHeldItem>)((ContainerType)Registry.ModContainers.PRINTOUT.get()), player.func_184586_b(hand), hand));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    private ItemStack createFromTitleAndText(String title, String[] text, String[] colours) {
        int i;
        CompoundNBT tag;
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (title != null) {
            stack.func_196082_o().func_74778_a(NBT_TITLE, title);
        }
        if (text != null) {
            tag = stack.func_196082_o();
            tag.func_74768_a(NBT_PAGES, text.length / 21);
            for (i = 0; i < text.length; ++i) {
                if (text[i] == null) continue;
                tag.func_74778_a(NBT_LINE_TEXT + i, text[i]);
            }
        }
        if (colours != null) {
            tag = stack.func_196082_o();
            for (i = 0; i < colours.length; ++i) {
                if (colours[i] == null) continue;
                tag.func_74778_a(NBT_LINE_COLOUR + i, colours[i]);
            }
        }
        return stack;
    }

    @Nonnull
    public static ItemStack createSingleFromTitleAndText(String title, String[] text, String[] colours) {
        return ((ItemPrintout)Registry.ModItems.PRINTED_PAGE.get()).createFromTitleAndText(title, text, colours);
    }

    @Nonnull
    public static ItemStack createMultipleFromTitleAndText(String title, String[] text, String[] colours) {
        return ((ItemPrintout)Registry.ModItems.PRINTED_PAGES.get()).createFromTitleAndText(title, text, colours);
    }

    @Nonnull
    public static ItemStack createBookFromTitleAndText(String title, String[] text, String[] colours) {
        return ((ItemPrintout)Registry.ModItems.PRINTED_BOOK.get()).createFromTitleAndText(title, text, colours);
    }

    public Type getType() {
        return this.type;
    }

    public static String getTitle(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_TITLE) ? nbt.func_74779_i(NBT_TITLE) : null;
    }

    public static int getPageCount(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_PAGES) ? nbt.func_74762_e(NBT_PAGES) : 1;
    }

    public static String[] getText(@Nonnull ItemStack stack) {
        return ItemPrintout.getLines(stack, NBT_LINE_TEXT);
    }

    public static String[] getColours(@Nonnull ItemStack stack) {
        return ItemPrintout.getLines(stack, NBT_LINE_COLOUR);
    }

    private static String[] getLines(@Nonnull ItemStack stack, String prefix) {
        CompoundNBT nbt = stack.func_77978_p();
        int numLines = ItemPrintout.getPageCount(stack) * 21;
        String[] lines = new String[numLines];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = nbt != null ? nbt.func_74779_i(prefix + i) : "";
        }
        return lines;
    }

    public static enum Type {
        PAGE,
        PAGES,
        BOOK;

    }
}

