/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.logger.ILogger;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.integration.crafttweaker.TrackingLogger;
import dan200.computercraft.shared.turtle.upgrades.TurtleAxe;
import dan200.computercraft.shared.turtle.upgrades.TurtleHoe;
import dan200.computercraft.shared.turtle.upgrades.TurtleShovel;
import dan200.computercraft.shared.turtle.upgrades.TurtleSword;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public class AddTurtleTool
implements IUndoableAction {
    private static final Map<String, Factory> kinds = new HashMap<String, Factory>();
    private final String id;
    private final ItemStack craftItem;
    private final ItemStack toolItem;
    private final String kind;
    private ITurtleUpgrade upgrade;

    public AddTurtleTool(String id, ItemStack craftItem, ItemStack toolItem, String kind) {
        this.id = id;
        this.craftItem = craftItem;
        this.toolItem = toolItem;
        this.kind = kind;
    }

    public void apply() {
        ITurtleUpgrade upgrade = this.upgrade;
        if (upgrade == null) {
            Factory factory = kinds.get(this.kind);
            if (factory == null) {
                ComputerCraft.log.error("Unknown turtle upgrade kind '{}' (this should have been rejected by verify!)", (Object)this.kind);
                return;
            }
            upgrade = this.upgrade = factory.create(new ResourceLocation(this.id), this.craftItem, this.toolItem);
        }
        try {
            TurtleUpgrades.register(upgrade);
        }
        catch (RuntimeException e) {
            ComputerCraft.log.error("Registration of turtle tool failed", (Throwable)e);
        }
    }

    public String describe() {
        return String.format("Add new turtle %s '%s' (crafted with '%s', uses a '%s')", this.kind, this.id, this.craftItem, this.toolItem);
    }

    public void undo() {
        if (this.upgrade != null) {
            TurtleUpgrades.remove(this.upgrade);
        }
    }

    public String describeUndo() {
        return String.format("Removing turtle upgrade %s.", this.id);
    }

    public boolean validate(ILogger logger) {
        TrackingLogger trackLog = new TrackingLogger(logger);
        if (this.craftItem.func_190926_b()) {
            trackLog.error("Crafting item stack is empty.");
        }
        if (this.craftItem.func_77951_h() || this.craftItem.func_77948_v() || this.craftItem.func_82837_s()) {
            trackLog.warning("Crafting item has NBT.");
        }
        if (this.toolItem.func_190926_b()) {
            trackLog.error("Tool item stack is empty.");
        }
        if (!kinds.containsKey(this.kind)) {
            trackLog.error(String.format("Unknown kind '%s'.", this.kind));
        }
        if (TurtleUpgrades.get(this.id) != null) {
            trackLog.error(String.format("An upgrade with the same name ('%s') has already been registered.", this.id));
        }
        return trackLog.isOk();
    }

    public boolean shouldApplyOn(LogicalSide side) {
        return this.shouldApplySingletons();
    }

    static {
        kinds.put("tool", TurtleTool::new);
        kinds.put("axe", TurtleAxe::new);
        kinds.put("hoe", TurtleHoe::new);
        kinds.put("shovel", TurtleShovel::new);
        kinds.put("sword", TurtleSword::new);
    }

    private static interface Factory {
        public TurtleTool create(ResourceLocation var1, ItemStack var2, ItemStack var3);
    }
}

