/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.function.Supplier;

public final class ComputerProxy {
    private final Supplier<TileComputerBase> get;

    public ComputerProxy(Supplier<TileComputerBase> get) {
        this.get = get;
    }

    protected TileComputerBase getTile() {
        return this.get.get();
    }

    public void turnOn() {
        TileComputerBase tile = this.getTile();
        ServerComputer computer = tile.getServerComputer();
        if (computer == null) {
            tile.startOn = true;
        } else {
            computer.turnOn();
        }
    }

    public void shutdown() {
        TileComputerBase tile = this.getTile();
        ServerComputer computer = tile.getServerComputer();
        if (computer == null) {
            tile.startOn = false;
        } else {
            computer.shutdown();
        }
    }

    public void reboot() {
        TileComputerBase tile = this.getTile();
        ServerComputer computer = tile.getServerComputer();
        if (computer == null) {
            tile.startOn = true;
        } else {
            computer.reboot();
        }
    }

    public int getID() {
        TileComputerBase tile = this.getTile();
        ServerComputer computer = tile.getServerComputer();
        return computer == null ? tile.getComputerID() : computer.getID();
    }

    public boolean isOn() {
        ServerComputer computer = this.getTile().getServerComputer();
        return computer != null && computer.isOn();
    }

    public String getLabel() {
        TileComputerBase tile = this.getTile();
        ServerComputer computer = tile.getServerComputer();
        return computer == null ? tile.getLabel() : computer.getLabel();
    }
}

