/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public final class ChatHelpers {
    private static final TextFormatting HEADER = TextFormatting.LIGHT_PURPLE;

    private ChatHelpers() {
    }

    public static IFormattableTextComponent coloured(String text, TextFormatting colour) {
        return new StringTextComponent(text == null ? "" : text).func_240699_a_(colour);
    }

    public static <T extends IFormattableTextComponent> T coloured(T component, TextFormatting colour) {
        component.func_240699_a_(colour);
        return component;
    }

    public static IFormattableTextComponent text(String text) {
        return new StringTextComponent(text == null ? "" : text);
    }

    public static IFormattableTextComponent translate(String text) {
        return new TranslationTextComponent(text == null ? "" : text);
    }

    public static IFormattableTextComponent translate(String text, Object ... args) {
        return new TranslationTextComponent(text == null ? "" : text, args);
    }

    public static IFormattableTextComponent list(ITextComponent ... children) {
        StringTextComponent component = new StringTextComponent("");
        for (ITextComponent child : children) {
            component.func_230529_a_(child);
        }
        return component;
    }

    public static IFormattableTextComponent position(BlockPos pos) {
        if (pos == null) {
            return ChatHelpers.translate("commands.computercraft.generic.no_position");
        }
        return ChatHelpers.translate("commands.computercraft.generic.position", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static IFormattableTextComponent bool(boolean value) {
        return value ? ChatHelpers.coloured(ChatHelpers.translate("commands.computercraft.generic.yes"), TextFormatting.GREEN) : ChatHelpers.coloured(ChatHelpers.translate("commands.computercraft.generic.no"), TextFormatting.RED);
    }

    public static ITextComponent link(IFormattableTextComponent component, String command, ITextComponent toolTip) {
        return ChatHelpers.link((ITextComponent)component, new ClickEvent(ClickEvent.Action.RUN_COMMAND, command), toolTip);
    }

    public static ITextComponent link(ITextComponent component, ClickEvent click, ITextComponent toolTip) {
        Style style = component.func_150256_b();
        if (style.func_240711_a_() == null) {
            style = style.func_240712_a_(TextFormatting.YELLOW);
        }
        style = style.func_240715_a_(click);
        style = style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)toolTip));
        return component.func_230532_e_().func_240703_c_(style);
    }

    public static IFormattableTextComponent header(String text) {
        return ChatHelpers.coloured(text, HEADER);
    }

    public static IFormattableTextComponent copy(String text) {
        StringTextComponent name = new StringTextComponent(text);
        Style style = name.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("gui.computercraft.tooltip.copy")));
        return name.func_240703_c_(style);
    }
}

