/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonElement;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.data.PrettyJsonWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.BlockModelProvider;
import net.minecraft.data.BlockModelWriter;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedBlockState;
import net.minecraft.data.ItemModelProvider;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModelProvider
implements IDataProvider {
    private final DataGenerator generator;
    private final Consumer<BlockModelProvider> blocks;
    private final Consumer<ItemModelProvider> items;

    public ModelProvider(DataGenerator generator, Consumer<BlockModelProvider> blocks, Consumer<ItemModelProvider> items) {
        this.generator = generator;
        this.blocks = blocks;
        this.items = items;
    }

    public void func_200398_a(@Nonnull DirectoryCache output) {
        HashMap blockStates = new HashMap();
        Consumer<IFinishedBlockState> addBlockState = generator -> {
            Block block = generator.func_230524_a_();
            if (blockStates.containsKey(block)) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
            blockStates.put(block, generator);
        };
        HashMap<ResourceLocation, BlockModelWriter> models = new HashMap<ResourceLocation, BlockModelWriter>();
        BiConsumer<ResourceLocation, Supplier> addModel = (id, contents) -> {
            if (models.containsKey(id)) {
                throw new IllegalStateException("Duplicate model definition for " + id);
            }
            models.put((ResourceLocation)id, (BlockModelWriter)contents);
        };
        HashSet explicitItems = new HashSet();
        this.blocks.accept(new BlockModelProvider(addBlockState, addModel, explicitItems::add));
        this.items.accept(new ItemModelProvider(addModel));
        for (Block block : ForgeRegistries.BLOCKS) {
            ResourceLocation model;
            Item item;
            if (!blockStates.containsKey(block) || (item = (Item)Item.field_179220_a.get(block)) == null || explicitItems.contains(item) || models.containsKey(model = ModelsResourceUtil.func_240219_a_((Item)item))) continue;
            models.put(model, new BlockModelWriter(ModelsResourceUtil.func_240221_a_((Block)block)));
        }
        this.saveCollection(output, this.generator.func_200391_b(), blockStates, ModelProvider::createBlockStatePath);
        this.saveCollection(output, this.generator.func_200391_b(), models, ModelProvider::createModelPath);
    }

    private <T> void saveCollection(DirectoryCache output, Path root, Map<T, ? extends Supplier<JsonElement>> items, BiFunction<Path, T, Path> getLocation) {
        for (Map.Entry<T, Supplier<JsonElement>> entry : items.entrySet()) {
            Path path = getLocation.apply(root, (Path)entry.getKey());
            try {
                PrettyJsonWriter.save(output, entry.getValue().get(), path);
            }
            catch (Exception exception) {
                ComputerCraft.log.error("Couldn't save {}", (Object)path, (Object)exception);
            }
        }
    }

    private static Path createBlockStatePath(Path path, Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        return path.resolve("assets/" + id.func_110624_b() + "/blockstates/" + id.func_110623_a() + ".json");
    }

    private static Path createModelPath(Path path, ResourceLocation id) {
        return path.resolve("assets/" + id.func_110624_b() + "/models/" + id.func_110623_a() + ".json");
    }

    @Nonnull
    public String func_200397_b() {
        return "Block State Definitions";
    }
}

