/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;

public class DirectBuffers {
    public static final boolean HAS_DSA;
    private static final MemoryUtil.MemoryAllocator ALLOCATOR;

    public static int createBuffer() {
        return HAS_DSA ? GL45C.glCreateBuffers() : GL15C.glGenBuffers();
    }

    public static void setBufferData(int type, int id, ByteBuffer buffer, int flags) {
        if (HAS_DSA) {
            GL45C.glNamedBufferData((int)id, (ByteBuffer)buffer, (int)flags);
        } else {
            GlStateManager.func_227724_g_((int)type, (int)id);
            GlStateManager.func_227655_a_((int)type, (ByteBuffer)buffer, (int)35044);
            GlStateManager.func_227724_g_((int)type, (int)0);
        }
    }

    public static void setEmptyBufferData(int type, int id, int flags) {
        if (HAS_DSA) {
            GL45C.glNamedBufferData((int)id, (long)0L, (int)flags);
        } else {
            GlStateManager.func_227724_g_((int)type, (int)id);
            GL45C.glBufferData((int)type, (long)0L, (int)35044);
            GlStateManager.func_227724_g_((int)type, (int)0);
        }
    }

    public static ByteBuffer createByteBuffer(int size) {
        long i = ALLOCATOR.malloc((long)size);
        if (i == 0L) {
            throw new OutOfMemoryError("Failed to allocate " + size + " bytes");
        }
        return MemoryUtil.memByteBuffer((long)i, (int)size);
    }

    public static ByteBuffer resizeByteBuffer(ByteBuffer buffer, int size) {
        long i = ALLOCATOR.realloc(MemoryUtil.memAddress0((Buffer)buffer), (long)size);
        if (i == 0L) {
            throw new OutOfMemoryError("Failed to resize buffer from " + buffer.capacity() + " bytes to " + size + " bytes");
        }
        return MemoryUtil.memByteBuffer((long)i, (int)size);
    }

    static {
        GLCapabilities capabilities = GL.getCapabilities();
        HAS_DSA = capabilities.OpenGL45 || capabilities.GL_ARB_direct_state_access;
        ALLOCATOR = MemoryUtil.getAllocator((boolean)false);
    }
}

