/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import dan200.computercraft.client.sound.DfpwmStream;
import dan200.computercraft.client.sound.SpeakerSound;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;

public class SpeakerInstance {
    public static final ResourceLocation DFPWM_STREAM = new ResourceLocation("computercraft", "speaker.dfpwm_fake_audio_should_not_be_played");
    private DfpwmStream currentStream;
    private SpeakerSound sound;

    SpeakerInstance() {
    }

    public synchronized void pushAudio(ByteBuf buffer) {
        SpeakerSound sound = this.sound;
        DfpwmStream stream = this.currentStream;
        if (stream == null) {
            stream = this.currentStream = new DfpwmStream();
        }
        boolean exhausted = stream.isEmpty();
        this.currentStream.push(buffer);
        if (exhausted && sound != null && sound.stream == stream && sound.field_184368_b != null) {
            sound.executor.execute(() -> {
                if (!sound.field_184368_b.func_216435_g()) {
                    sound.field_184368_b.func_216421_a(1);
                }
            });
        }
    }

    public void playAudio(SpeakerPosition position, float volume) {
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        if (this.sound != null && this.sound.stream != this.currentStream) {
            soundManager.func_147683_b((ISound)this.sound);
            this.sound = null;
        }
        if (this.sound != null && !soundManager.func_215294_c((ISound)this.sound)) {
            this.sound = null;
        }
        if (this.sound == null && this.currentStream != null) {
            this.sound = new SpeakerSound(DFPWM_STREAM, this.currentStream, position, volume, 1.0f);
            soundManager.func_147682_a((ISound)this.sound);
        }
    }

    public void playSound(SpeakerPosition position, ResourceLocation location, float volume, float pitch) {
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        this.currentStream = null;
        if (this.sound != null) {
            soundManager.func_147683_b((ISound)this.sound);
            this.sound = null;
        }
        this.sound = new SpeakerSound(location, null, position, volume, pitch);
        soundManager.func_147682_a((ISound)this.sound);
    }

    void setPosition(SpeakerPosition position) {
        if (this.sound != null) {
            this.sound.setPosition(position);
        }
    }

    void stop() {
        if (this.sound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.sound);
        }
        this.currentStream = null;
        this.sound = null;
    }
}

