/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.pocket;

import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public final class ClientPocketComputers {
    private static final Int2ObjectMap<PocketComputerData> instances = new Int2ObjectOpenHashMap();

    private ClientPocketComputers() {
    }

    public static void reset() {
        instances.clear();
    }

    public static void remove(int id) {
        instances.remove(id);
    }

    @Nonnull
    public static PocketComputerData get(int instanceId, boolean advanced) {
        PocketComputerData computer = (PocketComputerData)instances.get(instanceId);
        if (computer == null) {
            computer = new PocketComputerData(advanced);
            instances.put(instanceId, (Object)computer);
        }
        return computer;
    }

    @Nonnull
    public static PocketComputerData get(ItemStack stack) {
        ComputerFamily family = stack.func_77973_b() instanceof ItemComputer ? ((ItemComputer)stack.func_77973_b()).getFamily() : ComputerFamily.NORMAL;
        return ClientPocketComputers.get(ItemPocketComputer.getInstanceID(stack), family != ComputerFamily.NORMAL);
    }
}

